/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.collection;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public class FixedDeque<E>
implements Deque<E> {
    private final int maxSize;
    private final Deque<E> deque;

    public FixedDeque(int maxSize) {
        this.maxSize = maxSize;
        this.deque = new LinkedList();
    }

    public FixedDeque(int maxSize, Collection<? extends E> collection) {
        this.maxSize = maxSize;
        this.deque = new LinkedList<E>(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        return this.deque.toArray(a);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        return this.deque.containsAll(collection);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> collection) {
        if (!this.deque.addAll(collection)) {
            return false;
        }
        while (this.deque.size() > this.maxSize) {
            this.deque.pollLast();
        }
        return true;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> collection) {
        return this.deque.removeAll(collection);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        return this.deque.retainAll(collection);
    }

    @Override
    public void clear() {
        this.deque.clear();
    }

    @Override
    public void addFirst(E e) {
        if (this.deque.size() >= this.maxSize) {
            this.deque.removeLast();
        }
        this.deque.addFirst(e);
    }

    @Override
    public void addLast(E e) {
        if (this.deque.size() >= this.maxSize) {
            this.deque.removeFirst();
        }
        this.deque.addLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        if (this.deque.size() >= this.maxSize) {
            return false;
        }
        return this.deque.offerFirst(e);
    }

    @Override
    public boolean offerLast(E e) {
        if (this.deque.size() >= this.maxSize) {
            return false;
        }
        return this.deque.offerLast(e);
    }

    @Override
    public E removeFirst() {
        return this.deque.removeFirst();
    }

    @Override
    public E removeLast() {
        return this.deque.removeLast();
    }

    @Override
    public E pollFirst() {
        return this.deque.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.deque.pollLast();
    }

    @Override
    public E getFirst() {
        return this.deque.getFirst();
    }

    @Override
    public E getLast() {
        return this.deque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.deque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.deque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.deque.removeFirstOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.deque.removeLastOccurrence(o);
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.deque.contains(o);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return this.deque.iterator();
    }

    @Override
    @Nonnull
    public Iterator<E> descendingIterator() {
        return this.deque.descendingIterator();
    }
}

