/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.collection;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public abstract class Iterators2 {
    public static <E> ListIterator<E> filter(ListIterator<E> listIterator, Predicate<? super E> filter) {
        return new FilteringListIterator<E>(listIterator, filter);
    }

    static class FilteringListIterator<E>
    implements ListIterator<E> {
        private final Predicate<? super E> filter;
        private final ListIterator<E> listIterator;
        private int index;
        private int offset;
        @Nullable
        private E elementToReturn;
        private Accessed accessed = Accessed.NONE;

        FilteringListIterator(ListIterator<E> listIterator, Predicate<? super E> filter) {
            this.listIterator = Preconditions.checkNotNull(listIterator);
            this.filter = Preconditions.checkNotNull(filter);
            this.index = 0;
        }

        @Override
        public void add(E e) {
            this.moveBack();
            this.listIterator.add(e);
            ++this.index;
            this.accessed = Accessed.NONE;
        }

        @Override
        public boolean hasNext() {
            E element;
            if (this.elementToReturn != null && this.offset > 0) {
                return true;
            }
            this.elementToReturn = null;
            while (this.offset < 0) {
                this.listIterator.next();
                ++this.offset;
            }
            do {
                if (!this.listIterator.hasNext()) {
                    return false;
                }
                element = this.listIterator.next();
                ++this.offset;
            } while (!this.filter.apply(element));
            this.elementToReturn = element;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                E e = Preconditions.checkNotNull(this.elementToReturn);
                return e;
            }
            finally {
                this.offset = 0;
                this.accessed = Accessed.PREVIOUS;
                this.elementToReturn = null;
                ++this.index;
            }
        }

        @Override
        public boolean hasPrevious() {
            E element;
            if (this.elementToReturn != null && this.offset < 0) {
                return true;
            }
            this.elementToReturn = null;
            while (this.offset > 0) {
                this.listIterator.previous();
                --this.offset;
            }
            do {
                if (!this.listIterator.hasPrevious()) {
                    return false;
                }
                element = this.listIterator.previous();
                --this.offset;
            } while (!this.filter.apply(element));
            this.elementToReturn = element;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            try {
                E e = Preconditions.checkNotNull(this.elementToReturn);
                return e;
            }
            finally {
                this.offset = 0;
                this.accessed = Accessed.NEXT;
                this.elementToReturn = null;
                --this.index;
            }
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.moveBack();
            this.accessed.calibrate(this.listIterator);
            if (this.accessed == Accessed.PREVIOUS) {
                --this.index;
            }
            this.listIterator.remove();
            this.accessed = Accessed.NONE;
            this.elementToReturn = null;
        }

        @Override
        public void set(E e) {
            this.moveBack();
            this.accessed.calibrate(this.listIterator);
            this.listIterator.set(e);
        }

        private void moveBack() {
            while (this.offset > 0) {
                this.listIterator.previous();
                --this.offset;
            }
            while (this.offset < 0) {
                this.listIterator.next();
                ++this.offset;
            }
        }

        private static enum Accessed {
            NONE(false){

                @Override
                void calibrate(ListIterator<?> listIterator) {
                    throw new IllegalStateException();
                }
            }
            ,
            NEXT(true){

                @Override
                void calibrate(ListIterator<?> listIterator) {
                    listIterator.next();
                    listIterator.previous();
                }
            }
            ,
            PREVIOUS(true){

                @Override
                void calibrate(ListIterator<?> listIterator) {
                    listIterator.previous();
                    listIterator.next();
                }
            };

            final boolean exists;

            private Accessed(boolean accessed) {
                this.exists = accessed;
            }

            abstract void calibrate(ListIterator<?> var1);
        }
    }
}

