/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.collection;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingListIterator;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public abstract class ListIteratorView<T extends Serializable>
extends ForwardingListIterator<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    @Nullable
    transient ListIterator<T> delegate;
    @Nullable
    T current;
    int currentIndex = -1;

    public boolean hasCurrent() {
        return this.currentIndex >= 0;
    }

    public T current() {
        if (!this.hasCurrent()) {
            throw new NoSuchElementException("Cursor does not point to an element.  Use next() or previous() first.");
        }
        return (T)((Serializable)Preconditions.checkNotNull(this.current));
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    @Override
    public T next() {
        int nextIndex = this.nextIndex();
        this.current = (Serializable)super.next();
        this.currentIndex = nextIndex;
        return this.current;
    }

    @Override
    public T previous() {
        int previousIndex = this.previousIndex();
        this.current = (Serializable)super.previous();
        this.currentIndex = previousIndex;
        return this.current;
    }

    public ListIteratorView<T> reset() {
        this.delegate = null;
        this.currentIndex = -1;
        return this;
    }

    protected abstract ListIterator<T> load();

    @Override
    protected ListIterator<T> delegate() {
        if (this.delegate == null) {
            this.delegate = this.load();
            if (this.hasCurrent()) {
                Iterators.advance(this.delegate, this.currentIndex);
            }
        }
        return this.delegate;
    }
}

