/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.dummy;

import com.lyndir.lhunath.opal.system.logging.Logger;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputListener;

public class LoggingEventHandler
implements ComponentListener,
ContainerListener,
FocusListener,
AncestorListener,
HierarchyBoundsListener,
HierarchyListener,
WindowFocusListener,
WindowListener,
WindowStateListener,
PropertyChangeListener,
MouseInputListener,
MouseWheelListener,
KeyListener,
InputMethodListener {
    private static final Logger logger = Logger.get(LoggingEventHandler.class);
    private final String name;

    public static void watchComponentEvents(String name, JComponent component) {
        LoggingEventHandler handler = new LoggingEventHandler(name);
        component.addAncestorListener(handler);
        component.addComponentListener(handler);
        component.addContainerListener(handler);
        component.addFocusListener(handler);
        component.addHierarchyBoundsListener(handler);
        component.addHierarchyListener(handler);
        component.addPropertyChangeListener(handler);
    }

    public static void watchWindowEvents(String name, Window window) {
        LoggingEventHandler handler = new LoggingEventHandler(name);
        window.addComponentListener(handler);
        window.addContainerListener(handler);
        window.addFocusListener(handler);
        window.addHierarchyBoundsListener(handler);
        window.addHierarchyListener(handler);
        window.addPropertyChangeListener(handler);
        window.addWindowFocusListener(handler);
        window.addWindowListener(handler);
        window.addWindowStateListener(handler);
    }

    public static void watchInputEvents(String name, Component component) {
        LoggingEventHandler handler = new LoggingEventHandler(name);
        component.addInputMethodListener(handler);
        component.addKeyListener(handler);
        component.addMouseListener(handler);
        component.addMouseMotionListener(handler);
        component.addMouseWheelListener(handler);
    }

    public LoggingEventHandler(String name) {
        this.name = name;
    }

    @Override
    public void componentHidden(ComponentEvent event) {
        logger.dbg("%s: hidden [Id: %d]", this.name, event.getID());
    }

    @Override
    public void componentMoved(ComponentEvent event) {
        logger.dbg("%s: moved [Id: %d]", this.name, event.getID());
    }

    @Override
    public void componentResized(ComponentEvent event) {
        logger.dbg("%s: sized [Id: %d]", this.name, event.getID());
    }

    @Override
    public void componentShown(ComponentEvent event) {
        logger.dbg("%s: shown [Id: %d]", this.name, event.getID());
    }

    @Override
    public void componentAdded(ContainerEvent event) {
        logger.dbg("%s: added [Id: %d]", this.name, event.getID());
    }

    @Override
    public void componentRemoved(ContainerEvent event) {
        logger.dbg("%s: removed [Id: %d]", this.name, event.getID());
    }

    @Override
    public void focusGained(FocusEvent event) {
        logger.dbg("%s: focused [Id: %d]", this.name, event.getID());
    }

    @Override
    public void focusLost(FocusEvent event) {
        logger.dbg("%s: unfocused [Id: %d]", this.name, event.getID());
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        logger.dbg("%s: ancestor added [Id: %d]", this.name, event.getID());
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        logger.dbg("%s: ancestor moved [Id: %d]", this.name, event.getID());
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        logger.dbg("%s: ancestor removed [Id: %d]", this.name, event.getID());
    }

    @Override
    public void ancestorMoved(HierarchyEvent event) {
        logger.dbg("%s: hierarchy ancestor moved [Id: %d, Flags: %d]", this.name, event.getID(), event.getChangeFlags());
    }

    @Override
    public void ancestorResized(HierarchyEvent event) {
        logger.dbg("%s: hierarchy ancestor sized [Id: %d, Flags: %d]", this.name, event.getID(), event.getChangeFlags());
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        logger.dbg("%s: hierarchy changed [Id: %d, Flags: %d]", this.name, event.getID(), event.getChangeFlags());
    }

    @Override
    public void windowGainedFocus(WindowEvent event) {
        logger.dbg("%s: window focused [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowLostFocus(WindowEvent event) {
        logger.dbg("%s: window unfocused [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowActivated(WindowEvent event) {
        logger.dbg("%s: window activated [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowClosed(WindowEvent event) {
        logger.dbg("%s: window closed [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowClosing(WindowEvent event) {
        logger.dbg("%s: window closing [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
        logger.dbg("%s: window deactivated [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
        logger.dbg("%s: window deiconified [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowIconified(WindowEvent event) {
        logger.dbg("%s: window iconified [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowOpened(WindowEvent event) {
        logger.dbg("%s: window opened [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void windowStateChanged(WindowEvent event) {
        logger.dbg("%s: window state [Id: %d, State: From %d to %d]", this.name, event.getID(), event.getOldState(), event.getNewState());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.dbg("%s: property [Name: %s, Value: From %s to %s]", this.name, event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        logger.dbg("%s: clicked [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        logger.dbg("%s: entered [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void mouseExited(MouseEvent event) {
        logger.dbg("%s: exited [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void mousePressed(MouseEvent event) {
        logger.dbg("%s: pressed [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        logger.dbg("%s: released [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        logger.dbg("%s: dragged [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        logger.dbg("%s: moved [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        logger.dbg("%s: wheeled [Id: %d, Mod: %d, ModEx: %d, Button: %d, Clicks: %d, At: (%d,%d), ScrollType: %d, ScrollAmount: %d, ScrollRotation: %d, Time: %dms ago]", this.name, event.getID(), event.getModifiers(), event.getModifiersEx(), event.getButton(), event.getClickCount(), event.getX(), event.getY(), event.getScrollType(), event.getScrollAmount(), event.getWheelRotation(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void keyPressed(KeyEvent event) {
        logger.dbg("%s: key pressed [Id: %d, Char: %s (%d), Location: %d, Time: %dms ago]", this.name, event.getID(), Character.valueOf(event.getKeyChar()), event.getKeyCode(), event.getKeyLocation(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void keyReleased(KeyEvent event) {
        logger.dbg("%s: key released [Id: %d, Char: %s (%d), Location: %d, Time: %dms ago]", this.name, event.getID(), Character.valueOf(event.getKeyChar()), event.getKeyCode(), event.getKeyLocation(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void keyTyped(KeyEvent event) {
        logger.dbg("%s: key typed [Id: %d, Char: %s (%d), Location: %d, Time: %dms ago]", this.name, event.getID(), Character.valueOf(event.getKeyChar()), event.getKeyCode(), event.getKeyLocation(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        logger.dbg("%s: caret [Id: %d, Chars: %d, Text: %s, Time: %dms ago]", this.name, event.getID(), event.getCommittedCharacterCount(), event.getText(), System.currentTimeMillis() - event.getWhen());
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        logger.dbg("%s: text changed [Id: %d, Chars: %d, Text: %s, Time: %dms ago]", this.name, event.getID(), event.getCommittedCharacterCount(), event.getText(), System.currentTimeMillis() - event.getWhen());
    }
}

