/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.i18n;

import com.lyndir.lhunath.opal.system.i18n.internal.MessagesInvocationHandler;
import com.lyndir.lhunath.opal.system.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.annotation.Nullable;

public abstract class MessagesFactory {
    static final Logger logger = Logger.get(MessagesFactory.class);

    public static <M> M create(Class<M> localizationInterface) {
        return MessagesFactory.create(localizationInterface, null);
    }

    public static <M> M create(Class<M> localizationInterface, @Nullable Class<?> baseClass) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class[] proxyInterfaces = new Class[]{localizationInterface, Serializable.class};
        return localizationInterface.cast(Proxy.newProxyInstance(classLoader, proxyInterfaces, (InvocationHandler)new MessagesInvocationHandler(baseClass)));
    }

    public static void initialize(Object object, Class<?> localizationInterface) {
        MessagesFactory.initialize(object, "msgs", localizationInterface);
    }

    public static void initialize(Object object, String msgsFieldName, Class<?> localizationInterface) {
        try {
            Field field = object.getClass().getDeclaredField(msgsFieldName);
            field.setAccessible(true);
            field.set(object, MessagesFactory.create(localizationInterface));
            field.setAccessible(false);
        }
        catch (IllegalAccessException e) {
            throw logger.bug(e, "Field %s of class %s was inaccessible even though we tried setAccessible.", msgsFieldName, object.getClass());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field " + msgsFieldName + " of class " + object.getClass() + " not found.", e);
        }
    }
}

