/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.i18n;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.lyndir.lhunath.opal.system.i18n.PropertiesResourceBundle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.annotation.Nullable;

public class XMLResourceBundle
extends PropertiesResourceBundle {
    private static final XMLControl CONTROL = new XMLControl();

    XMLResourceBundle(Properties props) {
        super(props);
    }

    public static ResourceBundle getXMLBundle(String baseName) {
        return XMLResourceBundle.getBundle(baseName, CONTROL);
    }

    public static ResourceBundle getXMLBundle(String baseName, Locale locale) {
        return XMLResourceBundle.getBundle(baseName, locale, CONTROL);
    }

    public static ResourceBundle getXMLBundle(String baseName, Locale locale, ClassLoader loader) {
        return XMLResourceBundle.getBundle(baseName, locale, loader, CONTROL);
    }

    static class XMLControl
    extends ResourceBundle.Control {
        XMLControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            return ImmutableList.of("xml");
        }

        @Override
        @Nullable
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            Preconditions.checkNotNull(baseName);
            Preconditions.checkNotNull(locale);
            Preconditions.checkNotNull(format);
            Preconditions.checkNotNull(loader);
            if (!"xml".equals(format)) {
                return null;
            }
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, format);
            URL url = loader.getResource(resourceName);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            if (connection == null) {
                return null;
            }
            if (reload) {
                connection.setUseCaches(false);
            }
            InputStream stream = connection.getInputStream();
            Properties properties = new Properties();
            try (BufferedInputStream input = new BufferedInputStream(stream);){
                properties.loadFromXML(input);
            }
            return new XMLResourceBundle(properties);
        }
    }
}

