/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.i18n.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lyndir.lhunath.opal.system.collection.SSupplier;
import com.lyndir.lhunath.opal.system.i18n.BooleanKeyAppender;
import com.lyndir.lhunath.opal.system.i18n.KeyAppender;
import com.lyndir.lhunath.opal.system.i18n.KeyMatch;
import com.lyndir.lhunath.opal.system.i18n.XMLResourceBundle;
import com.lyndir.lhunath.opal.system.i18n.internal.MethodArgument;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.ObjectUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nullable;

public class MessagesInvocationHandler
implements InvocationHandler,
Serializable {
    static final Logger logger = Logger.get(MessagesInvocationHandler.class);
    private static final long serialVersionUID = 0L;
    private static final Map<Class<?>, Function<Supplier<String>, ?>> wrapperTypes = Maps.newHashMap();
    private static final Deque<Supplier<Locale>> localeSuppliers = Lists.newLinkedList();
    @Nullable
    Class<?> baseClass;

    public static <T> void registerWrapperType(Class<? super T> wrapperType, Function<Supplier<String>, T> wrapperValueFactory) {
        wrapperTypes.put(wrapperType, wrapperValueFactory);
    }

    public static void registerLocaleSupplier(Supplier<Locale> localeSupplier) {
        localeSuppliers.addFirst(localeSupplier);
    }

    public MessagesInvocationHandler(@Nullable Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (this.baseClass == null) {
            Class<?> methodType = method.getDeclaringClass();
            this.baseClass = methodType.getEnclosingClass();
            Preconditions.checkNotNull(this.baseClass, "Must be an inner class of the class by the name of the resource bundle or manually specify the context class.");
        }
        final String methodName = method.getName();
        ImmutableList.Builder methodArgsBuilder = ImmutableList.builder();
        if (args != null) {
            int argsLen = args.length;
            for (int a = 0; a < argsLen; ++a) {
                Object argValue = args[a];
                Annotation[] argAnnotations = method.getParameterAnnotations()[a];
                methodArgsBuilder.add(new MethodArgument(argValue, argAnnotations));
            }
        }
        ImmutableCollection methodArgs = methodArgsBuilder.build();
        SSupplier<String> valueSupplier = new SSupplier<String>((List)((Object)methodArgs)){
            final /* synthetic */ List val$methodArgs;
            {
                this.val$methodArgs = list;
            }

            @Override
            public String get() {
                Supplier localeSupplier;
                StringBuilder keyBuilder = new StringBuilder(methodName);
                logger.dbg("Base key: %s", keyBuilder.toString());
                LinkedList<Object> localizationArgs = new LinkedList<Object>();
                for (MethodArgument methodArg : this.val$methodArgs) {
                    Object argValue = methodArg.getUnwrappedValue();
                    List<Annotation> argAnnotations = methodArg.getAnnotations();
                    logger.dbg("Considering argument %s", methodArg);
                    boolean useValue = true;
                    for (Annotation argAnnotation : argAnnotations) {
                        Annotation annotation;
                        if (KeyAppender.class.isInstance(argAnnotation)) {
                            annotation = (KeyAppender)argAnnotation;
                            useValue = annotation.useValue();
                            if (argValue == null) {
                                this.appendKey(keyBuilder, annotation.nullKey());
                                continue;
                            }
                            this.appendKey(keyBuilder, annotation.notNullKey());
                            if (annotation.value().length == 0) {
                                this.appendKey(keyBuilder, argValue.toString());
                                continue;
                            }
                            for (KeyMatch match : annotation.value()) {
                                logger.dbg("With match: %s, ", match);
                                boolean matches = false;
                                if (!Double.isNaN(match.ifNum()) && Number.class.isInstance(argValue) && match.ifNum() == ((Number)argValue).doubleValue()) {
                                    matches = true;
                                }
                                if (!matches && match.ifString() != "KeyMatch.unset" && match.ifString().equals(argValue.toString())) {
                                    matches = true;
                                }
                                if (!matches && match.ifClass() != KeyMatch.CLASS_UNSET && match.ifClass().equals(argValue)) {
                                    matches = true;
                                }
                                if (matches) {
                                    this.appendKey(keyBuilder, match.key());
                                    continue;
                                }
                                if (match.elseKey() == "KeyMatch.unset") continue;
                                this.appendKey(keyBuilder, match.elseKey());
                            }
                            continue;
                        }
                        if (!BooleanKeyAppender.class.isInstance(argAnnotation)) continue;
                        annotation = (BooleanKeyAppender)argAnnotation;
                        useValue = false;
                        Preconditions.checkArgument(Boolean.class.isInstance(argValue), "BooleanKeyAppender for method %s, expects a Boolean value but found: %s", methodName, argValue);
                        if (Boolean.TRUE.equals(argValue)) {
                            this.appendKey(keyBuilder, annotation.y());
                        }
                        if (!Boolean.FALSE.equals(argValue)) continue;
                        this.appendKey(keyBuilder, annotation.n());
                    }
                    if (!useValue) continue;
                    logger.dbg("Using argument value.", new Object[0]);
                    localizationArgs.add(methodArg.getLocalizedUnwrappedValue());
                }
                String key = keyBuilder.toString();
                logger.dbg("Resolving localization value of key: %s, in baseClass: %s, with arguments: %s", key, MessagesInvocationHandler.this.baseClass, localizationArgs);
                Locale locale = null;
                Iterator i$ = localeSuppliers.iterator();
                while (i$.hasNext() && (locale = (Locale)(localeSupplier = (Supplier)i$.next()).get()) == null) {
                }
                ResourceBundle resourceBundle = XMLResourceBundle.getXMLBundle(MessagesInvocationHandler.this.baseClass.getCanonicalName(), ObjectUtils.ifNotNullElse(locale, Locale.getDefault()), MessagesInvocationHandler.this.baseClass.getClassLoader());
                try {
                    return MessageFormat.format(resourceBundle.getString(key), localizationArgs.toArray());
                }
                catch (MissingResourceException e) {
                    throw new MissingResourceException(String.format("Missing resource for: %s, at key: %s.", MessagesInvocationHandler.this.baseClass, e.getKey()), MessagesInvocationHandler.this.baseClass.getCanonicalName(), e.getKey());
                }
            }

            private StringBuilder appendKey(StringBuilder keyBuilder, String keyPart) {
                if (keyPart != null && !keyPart.isEmpty()) {
                    logger.dbg("Appending key part: %s", keyPart);
                    keyBuilder.append('.').append(keyPart);
                }
                return keyBuilder;
            }
        };
        if (Supplier.class.isAssignableFrom(method.getReturnType())) {
            return valueSupplier;
        }
        for (Map.Entry<Class<?>, Function<Supplier<String>, ?>> classFunctionEntry : wrapperTypes.entrySet()) {
            if (!classFunctionEntry.getKey().isAssignableFrom(method.getReturnType())) continue;
            return classFunctionEntry.getValue().apply((Supplier<String>)valueSupplier);
        }
        return valueSupplier.get();
    }

    static {
        MessagesInvocationHandler.registerLocaleSupplier(new Supplier<Locale>(){

            @Override
            public Locale get() {
                return Locale.getDefault();
            }
        });
    }
}

