/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.i18n.internal;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lyndir.lhunath.opal.system.i18n.Localized;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class MethodArgument {
    private static final Map<Class<?>, Function<Object, ?>> unwrapperTypes = Maps.newHashMap();
    private final Object value;
    private final List<Annotation> annotations;

    public static <T> void registerWrapperType(Class<T> wrapperType, Function<T, ?> valueUnwrapperFactory) {
        unwrapperTypes.put(wrapperType, valueUnwrapperFactory);
    }

    public MethodArgument(Object value, Iterable<Annotation> annotations) {
        this.value = value;
        this.annotations = Lists.newArrayList(annotations);
    }

    public MethodArgument(Object value, Annotation ... annotations) {
        this.value = value;
        this.annotations = Lists.newArrayList(annotations);
    }

    public Object getValue() {
        return this.value;
    }

    @Nullable
    public Object getUnwrappedValue() {
        Object unwrappedValue = this.getValue();
        if (unwrappedValue == null) {
            return null;
        }
        if (Supplier.class.isInstance(unwrappedValue)) {
            unwrappedValue = ((Supplier)unwrappedValue).get();
        }
        for (Map.Entry<Class<?>, Function<Object, ?>> unwrapperType : unwrapperTypes.entrySet()) {
            if (!unwrapperType.getKey().isInstance(unwrappedValue)) continue;
            unwrappedValue = unwrapperType.getValue().apply(unwrappedValue);
        }
        return unwrappedValue;
    }

    @Nullable
    public Object getLocalizedUnwrappedValue() {
        Object unwrappedValue = this.getUnwrappedValue();
        if (unwrappedValue == null) {
            return null;
        }
        if (Localized.class.isInstance(unwrappedValue)) {
            unwrappedValue = ((Localized)unwrappedValue).getLocalizedInstance();
        }
        return unwrappedValue;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return String.format("{MethodArg: unwrapped=%s, annotations=%s}", this.getUnwrappedValue(), this.getAnnotations());
    }
}

