/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.logging;

import com.lyndir.lhunath.opal.system.util.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class LogFormatter
extends Formatter {
    private static final String[] skipPackages = new String[]{"com.lyndir.lhunath.opal", "java", "sun", "com.sun"};
    protected final Map<Level, String> levelColor = new HashMap<Level, String>();
    protected boolean initialized;
    protected boolean verbose;

    protected LogFormatter() {
        this.setVerbose(true);
    }

    protected LogFormatter(boolean verbosity) {
        this.setVerbose(verbosity);
    }

    protected abstract void setColors();

    @Override
    public String format(LogRecord record) {
        String source;
        StackTraceElement element;
        if (!this.initialized) {
            this.setColors();
            this.initialized = true;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Throwable error = record.getThrown();
        if (error != null) {
            Throwable e = error;
            while (e.getCause() != null && !(e.getCause() instanceof RuntimeException)) {
                e = e.getCause();
            }
            stackTrace = e.getStackTrace();
        }
        StackTraceElement sourceElement = null;
        if (stackTrace.length > 0) {
            sourceElement = stackTrace[0];
        }
        StackTraceElement[] arr$ = stackTrace;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && LogFormatter.isIgnored((sourceElement = (element = arr$[i$])).getClassName()); ++i$) {
        }
        String realSource = "";
        String relSource = "";
        if (stackTrace.length > 0 && !stackTrace[0].equals(sourceElement)) {
            realSource = String.format("(%s:%d) %s.%s()", stackTrace[0].getFileName(), stackTrace[0].getLineNumber(), TypeUtils.compressSignature(stackTrace[0].getClassName()), stackTrace[0].getMethodName());
        }
        if (sourceElement != null) {
            relSource = String.format("(%s:%d) %s.%s()", sourceElement.getFileName(), sourceElement.getLineNumber(), TypeUtils.compressSignature(sourceElement.getClassName()), sourceElement.getMethodName());
        }
        if ((source = realSource + (realSource.isEmpty() ? "" : ", ") + relSource).isEmpty()) {
            source = "[Unknown Source]";
        }
        StringBuilder messageBuilder = new StringBuilder();
        if (error != null) {
            for (Throwable e = error; e != null; e = e.getCause()) {
                messageBuilder.insert(0, String.format("(%s:%d) %s: %s%n", e.getStackTrace().length > 0 ? e.getStackTrace()[0].getFileName() : "n/a", e.getStackTrace().length > 0 ? e.getStackTrace()[0].getLineNumber() : -1, e.getClass().getName(), e.getLocalizedMessage()));
            }
        }
        if (record.getMessage() != null && !record.getMessage().isEmpty()) {
            messageBuilder.insert(0, record.getMessage() + System.lineSeparator());
        }
        String message = messageBuilder.toString().trim();
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.levelColor.get(record.getLevel()));
        String prefix = "$1 #  ";
        if (record.getLevel().intValue() > Level.INFO.intValue()) {
            buffer.append(String.format("[ %7s | %-30s ]:%n", record.getLevel().getLocalizedName(), source));
        } else {
            prefix = String.format("%s [ %-7s ]  ", prefix, record.getLevel().getLocalizedName());
        }
        buffer.append(message.replaceAll("([\r\n]|^)", prefix));
        if (this.isVerbose() && error != null && stackTrace.length > 0) {
            for (StackTraceElement e : stackTrace) {
                buffer.append(String.format("%n %s      %s", Character.valueOf(LogFormatter.isIgnored(e.getClassName()) ? (char)'-' : '>'), e));
            }
        }
        buffer.append(this.levelColor.get(null));
        return buffer.toString();
    }

    private static boolean isIgnored(String classOrPackage) {
        for (String skipPackage : skipPackages) {
            if (!classOrPackage.startsWith(skipPackage)) continue;
            return true;
        }
        return false;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

