/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.logging;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.lyndir.lhunath.opal.system.logging.Markers;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class Logger
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Class<?> type;
    @Nullable
    private transient org.slf4j.Logger logger;

    public static Logger get(Class<?> type) {
        return new Logger(type);
    }

    public Logger trc(@Nullable Marker marker, @Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        if (this.slf4j().isTraceEnabled()) {
            this.slf4j().trace(marker, String.format(descriptionFormat, descriptionArguments), cause);
        }
        return this;
    }

    public Logger trc(@Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        return this.trc(null, cause, descriptionFormat, descriptionArguments);
    }

    public Logger trc(String descriptionFormat, Object ... descriptionArguments) {
        return this.trc(null, descriptionFormat, descriptionArguments);
    }

    public Logger dbg(@Nullable Marker marker, @Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        if (this.slf4j().isDebugEnabled()) {
            this.slf4j().debug(marker, String.format(descriptionFormat, descriptionArguments), cause);
        }
        return this;
    }

    public Logger dbg(@Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        return this.dbg(null, cause, descriptionFormat, descriptionArguments);
    }

    public Logger dbg(String descriptionFormat, Object ... descriptionArguments) {
        return this.dbg(null, descriptionFormat, descriptionArguments);
    }

    public Logger inf(@Nullable Marker marker, @Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        if (this.slf4j().isInfoEnabled()) {
            this.slf4j().info(marker, String.format(descriptionFormat, descriptionArguments), cause);
        }
        return this;
    }

    public Logger inf(@Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        return this.inf(null, cause, descriptionFormat, descriptionArguments);
    }

    public Logger inf(String descriptionFormat, Object ... descriptionArguments) {
        return this.inf(null, descriptionFormat, descriptionArguments);
    }

    public Logger wrn(@Nullable Marker marker, @Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        if (this.slf4j().isWarnEnabled()) {
            this.slf4j().warn(marker, String.format(descriptionFormat, descriptionArguments), cause);
        }
        return this;
    }

    public Logger wrn(@Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        return this.wrn(null, cause, descriptionFormat, descriptionArguments);
    }

    public Logger wrn(String descriptionFormat, Object ... descriptionArguments) {
        return this.wrn(null, descriptionFormat, descriptionArguments);
    }

    public Logger err(@Nullable Marker marker, @Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        if (this.slf4j().isErrorEnabled()) {
            this.slf4j().error(marker, String.format(descriptionFormat, descriptionArguments), cause);
        }
        return this;
    }

    public Logger err(@Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        return this.err(null, cause, descriptionFormat, descriptionArguments);
    }

    public Logger err(String descriptionFormat, Object ... descriptionArguments) {
        return this.err(null, descriptionFormat, descriptionArguments);
    }

    public Logger audit(String descriptionFormat, Object ... descriptionArguments) {
        return this.inf(Markers.AUDIT, null, descriptionFormat, descriptionArguments);
    }

    public RuntimeException bug(@Nonnull Throwable cause) {
        return Preconditions.checkNotNull(this.bug(Preconditions.checkNotNull(cause), "Unexpected Error", new Object[0]));
    }

    public RuntimeException bug(@Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        this.err(Markers.BUG, cause, descriptionFormat, descriptionArguments);
        return cause == null ? new RuntimeException(String.format(descriptionFormat, descriptionArguments)) : Throwables.propagate(cause);
    }

    public RuntimeException bug(String descriptionFormat, Object ... descriptionArguments) {
        return this.bug(null, descriptionFormat, descriptionArguments);
    }

    public Logger security(@Nullable Throwable cause, String descriptionFormat, Object ... descriptionArguments) {
        return this.wrn(Markers.SECURITY, cause, descriptionFormat, descriptionArguments);
    }

    public Logger security(String descriptionFormat, Object ... descriptionArguments) {
        return this.security(null, descriptionFormat, descriptionArguments);
    }

    public org.slf4j.Logger slf4j() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.type);
        }
        return this.logger;
    }

    private Logger(Class<?> type) {
        this.type = type;
    }
}

