/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.logging;

import com.google.common.collect.ImmutableMap;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.logging.UserLogMessage;
import com.lyndir.lhunath.opal.system.util.ObjectUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UserLog {
    private static final ThreadLocal<EnumMap<Level, Map<Class<?>, List<UserLogMessage>>>> log = new ThreadLocal<EnumMap<Level, Map<Class<?>, List<UserLogMessage>>>>(){

        @Override
        protected EnumMap<Level, Map<Class<?>, List<UserLogMessage>>> initialValue() {
            return new EnumMap(Level.class);
        }
    };
    private final Logger logger;
    private final Class<?> type;

    public static UserLog get(Class<?> type) {
        return new UserLog(type);
    }

    public static Map<Class<?>, List<UserLogMessage>> popLogForLevel(Level level) {
        Map<Class<?>, List<UserLogMessage>> levelLog = log.get().get((Object)level);
        if (levelLog == null) {
            return ImmutableMap.of();
        }
        log.get().put(level, null);
        return levelLog;
    }

    private UserLog(Class<?> type) {
        this.type = type;
        this.logger = Logger.get(type);
    }

    public UserLog inf(UserLogMessage message) {
        this.logger.inf(ObjectUtils.toString(message), new Object[0]);
        return this.log(Level.INFO, message);
    }

    public UserLog wrn(UserLogMessage message) {
        this.logger.inf(ObjectUtils.toString(message), new Object[0]);
        return this.log(Level.WARNING, message);
    }

    public UserLog err(UserLogMessage message) {
        this.logger.inf(ObjectUtils.toString(message), new Object[0]);
        return this.log(Level.ERROR, message);
    }

    private UserLog log(Level level, UserLogMessage message) {
        List<UserLogMessage> typeLog;
        Map<Class<?>, List<UserLogMessage>> levelLog = log.get().get((Object)level);
        if (levelLog == null) {
            levelLog = new HashMap();
            log.get().put(level, levelLog);
        }
        if ((typeLog = levelLog.get(this.type)) == null) {
            typeLog = new LinkedList<UserLogMessage>();
            levelLog.put(this.type, typeLog);
        }
        typeLog.add(message);
        return this;
    }

    public static enum Level {
        INFO,
        WARNING,
        ERROR;

    }
}

