/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.collect.ObjectArrays;
import java.util.Collection;

public abstract class ArrayUtils {
    public static boolean hasIndex(int index, Object ... array) {
        return array != null && array.length >= index + 1;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] array, T ... elements) {
        if (elements.length == 0) {
            return array;
        }
        T[] concatenation = ObjectArrays.newArray(array, array.length + elements.length);
        System.arraycopy(array, 0, concatenation, 0, array.length);
        System.arraycopy(elements, 0, concatenation, array.length, elements.length);
        return concatenation;
    }

    public static byte[] concatBytes(byte[] array, byte ... elements) {
        if (elements.length == 0) {
            return array;
        }
        byte[] concatenation = new byte[array.length + elements.length];
        System.arraycopy(array, 0, concatenation, 0, array.length);
        System.arraycopy(elements, 0, concatenation, array.length, elements.length);
        return concatenation;
    }

    public static byte[] concatBytes(byte[] array, int ... elements) {
        if (elements.length == 0) {
            return array;
        }
        byte[] concatenation = new byte[array.length + elements.length];
        System.arraycopy(array, 0, concatenation, 0, array.length);
        for (int e = 0; e < elements.length; ++e) {
            concatenation[array.length + e] = (byte)elements[e];
        }
        return concatenation;
    }

    public static <T> T[] copyOf(Class<T> type, Collection<T> elements) {
        return ArrayUtils.unsafeCopyOf(type, elements.toArray());
    }

    @SafeVarargs
    public static <T> T[] of(T ... elements) {
        return elements;
    }

    public static byte[] ofBytes(byte ... elements) {
        return elements;
    }

    public static byte[] ofBytes(int ... elements) {
        byte[] array = new byte[elements.length];
        for (int e = 0; e < elements.length; ++e) {
            array[e] = (byte)elements[e];
        }
        return array;
    }

    public static <T> T[] unsafeCopyOf(Class<T> type, Object ... elements) {
        T[] array = ObjectArrays.newArray(type, elements.length);
        System.arraycopy(elements, 0, array, 0, elements.length);
        return array;
    }

    public static <T, U extends T> boolean inArray(T[] array, U search) {
        for (T element : array) {
            if (!search.equals(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] skip(Class<T> arrayType, T[] commandNameAndArguments, int numberToSkip) {
        T[] trimmedArray = ObjectArrays.newArray(arrayType, commandNameAndArguments.length - numberToSkip);
        System.arraycopy(commandNameAndArguments, numberToSkip, trimmedArray, 0, trimmedArray.length);
        return trimmedArray;
    }

    public static <T> T[] trim(Class<T> arrayType, T[] commandNameAndArguments, int numberToTrim) {
        T[] trimmedArray = ObjectArrays.newArray(arrayType, commandNameAndArguments.length - numberToTrim);
        System.arraycopy(commandNameAndArguments, 0, trimmedArray, 0, trimmedArray.length);
        return trimmedArray;
    }
}

