/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.NNFunctionNN;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class CollectionUtils {
    static final Logger logger = Logger.get(CollectionUtils.class);

    public static boolean recurseContains(@Nonnull Iterable<?> collection, @Nullable Object o) {
        for (Object co : collection) {
            if (!co.equals(o) && (!(co instanceof Collection) || !CollectionUtils.recurseContains((Iterable)co, o))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualElements(@Nonnull Collection<?> c1, @Nonnull Collection<?> c2) {
        Integer count;
        if (c1.size() != c2.size()) {
            return false;
        }
        HashMap<?, Integer> objectsCount = Maps.newHashMap();
        for (Object c1Object : c1) {
            count = (Integer)objectsCount.get(c1Object);
            count = (count == null ? 0 : count) + 1;
            objectsCount.put(c1Object, count);
        }
        for (Object c2Object : c2) {
            count = (Integer)objectsCount.get(c2Object);
            count = (count == null ? 0 : count) - 1;
            if (count > 0) {
                objectsCount.put(c2Object, count);
                continue;
            }
            if (count == 0) {
                objectsCount.remove(c2Object);
                continue;
            }
            return false;
        }
        return objectsCount.isEmpty();
    }

    @Nullable
    public static <E> E firstElementOfType(@Nonnull Class<E> type, @Nonnull Iterable<? super E> elements) {
        for (E element : elements) {
            if (!type.isInstance(element)) continue;
            return type.cast(element);
        }
        return null;
    }

    @Nonnull
    public static <E> List<E> elementsOfType(@Nonnull Class<E> type, @Nonnull Iterable<? super E> elements) {
        LinkedList<E> elementsOfType = Lists.newLinkedList();
        for (E element : elements) {
            if (!type.isInstance(element)) continue;
            elementsOfType.add(type.cast(element));
        }
        return elementsOfType;
    }

    public static <K extends Enum<K>, V> ImmutableMap<K, V> immutableEnumMap(Class<K> enumType, NNFunctionNN<K, V> valueForKey) {
        ImmutableMap.Builder<Enum, V> builder = ImmutableMap.builder();
        for (Enum constant : (Enum[])enumType.getEnumConstants()) {
            builder.put(constant, valueForKey.apply(constant));
        }
        return Maps.immutableEnumMap(builder.build());
    }
}

