/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.base.Optional;
import com.google.common.base.Verify;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.Throw;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConversionUtils {
    static final Logger logger = Logger.get(ConversionUtils.class);

    public static Optional<Long> toLong(@Nullable Object object) {
        if (object == null || object instanceof Long) {
            return Optional.fromNullable((Long)object);
        }
        try {
            return Optional.of(Long.valueOf(object.toString()));
        }
        catch (NumberFormatException e) {
            logger.wrn(e, "Malformed long: %s", object);
            return Optional.absent();
        }
    }

    public static long toLongNN(@Nullable Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        try {
            return Long.valueOf(object.toString());
        }
        catch (NumberFormatException e) {
            logger.wrn(e, "Malformed long: %s", object);
            return 0L;
        }
    }

    @Nonnull
    public static Optional<Integer> toInteger(@Nullable Object object) {
        if (object == null || object instanceof Integer) {
            return Optional.fromNullable((Integer)object);
        }
        try {
            return Optional.of(Integer.valueOf(object.toString()));
        }
        catch (NumberFormatException e) {
            logger.wrn(e, "Malformed integer: %s", object);
            return Optional.absent();
        }
    }

    public static int toIntegerNN(@Nullable Object object) {
        if (object == null) {
            return 0;
        }
        if (Integer.class.isInstance(object)) {
            return (Integer)object;
        }
        if (Integer.TYPE.isInstance(object)) {
            return (Integer)object;
        }
        try {
            return Integer.valueOf(object.toString());
        }
        catch (NumberFormatException e) {
            logger.wrn(e, "Malformed integer: %s", object);
            return 0;
        }
    }

    @Nonnull
    public static Optional<Double> toDouble(@Nullable Object object) {
        if (object == null || object instanceof Double) {
            return Optional.fromNullable((Double)object);
        }
        try {
            return Optional.of(Double.parseDouble(object.toString()));
        }
        catch (NumberFormatException e) {
            logger.wrn(e, "Malformed double: %s", object);
            return Optional.absent();
        }
    }

    public static double toDoubleNN(@Nullable Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        try {
            return Double.valueOf(object.toString());
        }
        catch (NumberFormatException e) {
            logger.wrn(e, "Malformed double: %s", object);
            return 0.0;
        }
    }

    @Nonnull
    public static Optional<Boolean> toBoolean(@Nullable Object object) {
        if (object == null || object instanceof Boolean) {
            return Optional.fromNullable((Boolean)object);
        }
        return Optional.of(Boolean.parseBoolean(object.toString()));
    }

    public static boolean toBooleanNN(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean(object.toString());
    }

    @Nonnull
    public static Optional<String> toString(@Nullable Object object) {
        if (object == null || object instanceof String) {
            return Optional.fromNullable((String)object);
        }
        return Optional.of(object.toString());
    }

    @Nonnull
    public static String toStringNN(@Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    @Nonnull
    public static Optional<URL> toURL(@Nullable Object url) {
        if (url == null || url instanceof URL) {
            return Optional.fromNullable((URL)url);
        }
        try {
            return Optional.of(new URL(url.toString()));
        }
        catch (MalformedURLException e) {
            logger.wrn(e, "Malformed URL: %s", url);
            return Optional.absent();
        }
    }

    @Nonnull
    public static URL toURLNN(@Nonnull Object url) {
        if (url instanceof URL) {
            return (URL)url;
        }
        try {
            return new URL(Verify.verifyNotNull(url, "Missing URL.", new Object[0]).toString());
        }
        catch (MalformedURLException e) {
            throw Throw.propagate(e, "Malformed URL: %s", url);
        }
    }
}

