/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.lyndir.lhunath.opal.system.logging.Logger;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Instant;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public abstract class DateUtils {
    private static final ThreadLocal<Stack<Timer>> currentTimer = new ThreadLocal<Stack<Timer>>(){

        @Override
        protected Stack<Timer> initialValue() {
            return new Stack<Timer>();
        }
    };
    private static final ImmutableMap<DurationFieldType, DateTimeFieldType> types;
    private static final ImmutableList<DateTimeFieldType> stdDateTimeFields;
    private static final Pattern LETTERS;
    public static final Map<Integer, String> calendarDesc;
    public static final Map<Integer, String> calendarFormat;
    public static final ImmutableList<Integer> calendarFields;

    public static Timer startTiming(String format, Object ... args) {
        Timer timer = new Timer(String.format(format, args));
        currentTimer.get().push(timer);
        return timer;
    }

    public static Timer popTimer() {
        return currentTimer.get().pop();
    }

    public static boolean removeTimer(Timer timer) {
        return currentTimer.get().remove(timer);
    }

    public static String calendarSuffix(int field) {
        return LETTERS.matcher(calendarFormat.get(field)).replaceAll("");
    }

    public static ReadablePeriod period(ReadableInstant from, ReadableInstant to, DateTimeFieldType field) {
        PeriodType periodType = PeriodType.forFields(DateUtils.convertAll(field));
        return new Period(DateUtils.truncate(from, field), DateUtils.truncate(to, field), periodType);
    }

    public static DurationFieldType convert(DateTimeFieldType field) {
        return field.getDurationType();
    }

    public static DurationFieldType[] convert(DateTimeFieldType ... fields) {
        return DateUtils.convertAll(fields);
    }

    public static DurationFieldType[] convertAll(DateTimeFieldType ... fields) {
        DurationFieldType[] durationFields = new DurationFieldType[fields.length];
        int fieldsLength = fields.length;
        for (int i = 0; i < fieldsLength; ++i) {
            durationFields[i] = DateUtils.convert(fields[i]);
        }
        return durationFields;
    }

    public static DateTimeFieldType convert(DurationFieldType field) {
        return types.get(field);
    }

    public static DateTimeFieldType[] convert(DurationFieldType ... fields) {
        return DateUtils.convertAll(fields);
    }

    public static DateTimeFieldType[] convertAll(DurationFieldType ... fields) {
        DateTimeFieldType[] dateTimeFieldTypes = new DateTimeFieldType[fields.length];
        int fieldsLength = fields.length;
        for (int i = 0; i < fieldsLength; ++i) {
            dateTimeFieldTypes[i] = DateUtils.convert(fields[i]);
        }
        return dateTimeFieldTypes;
    }

    public static ReadableInstant truncate(ReadableInstant instant, DateTimeFieldType field) {
        DateTime zero = new DateTime(0L);
        PeriodType periodType = PeriodType.forFields(DateUtils.convertAll(field));
        Period fieldPeriod = new Period((ReadableInstant)zero, instant, periodType);
        int fieldQuantity = fieldPeriod.get(field.getDurationType());
        return zero.property(field).addToCopy(fieldQuantity);
    }

    public static List<DateTimeFieldType> fieldsFrom(DateTimeFieldType startField) {
        return DateUtils.fieldsFrom(startField, true);
    }

    public static ImmutableList<DateTimeFieldType> fieldsFrom(DateTimeFieldType startField, boolean smallToLarge) {
        ImmutableList.Builder resultFieldsBuilder = ImmutableList.builder();
        AbstractCollection fields = stdDateTimeFields;
        if (!smallToLarge) {
            fields = Lists.newArrayList(fields);
            Collections.reverse(fields);
        }
        boolean foundStart = false;
        for (DateTimeFieldType field : fields) {
            if (field.equals(startField)) {
                foundStart = true;
            }
            if (!foundStart) continue;
            resultFieldsBuilder.add(field);
        }
        return resultFieldsBuilder.build();
    }

    static {
        LETTERS = Pattern.compile("[a-zA-Z]");
        calendarDesc = ImmutableMap.builder().put(14, "Millisecond").put(13, "Second").put(12, "Minute").put(11, "Hour").put(5, "Day").put(2, "Month").put(1, "Year").build();
        calendarFormat = ImmutableMap.builder().put(14, "SSSS").put(13, "ss.").put(12, "mm:").put(11, "HH:").put(5, "dd ").put(2, "MM/").put(1, "yyyy/").build();
        calendarFields = ImmutableList.of(Integer.valueOf(14), Integer.valueOf(13), Integer.valueOf(12), Integer.valueOf(11), Integer.valueOf(5), Integer.valueOf(2), Integer.valueOf(1));
        ImmutableMap.Builder<DurationFieldType, DateTimeFieldType> typesBuilder = ImmutableMap.builder();
        types = typesBuilder.put(DurationFieldType.eras(), DateTimeFieldType.era()).put(DurationFieldType.centuries(), DateTimeFieldType.centuryOfEra()).put(DurationFieldType.years(), DateTimeFieldType.year()).put(DurationFieldType.months(), DateTimeFieldType.monthOfYear()).put(DurationFieldType.weeks(), DateTimeFieldType.weekOfWeekyear()).put(DurationFieldType.days(), DateTimeFieldType.dayOfMonth()).put(DurationFieldType.halfdays(), DateTimeFieldType.halfdayOfDay()).put(DurationFieldType.hours(), DateTimeFieldType.hourOfDay()).put(DurationFieldType.minutes(), DateTimeFieldType.minuteOfDay()).put(DurationFieldType.seconds(), DateTimeFieldType.secondOfMinute()).put(DurationFieldType.millis(), DateTimeFieldType.millisOfSecond()).build();
        ImmutableList.Builder stdDateTimeFieldsBuilder = ImmutableList.builder();
        stdDateTimeFieldsBuilder.add(new DateTimeFieldType[]{DateTimeFieldType.millisOfSecond(), DateTimeFieldType.secondOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.hourOfDay(), DateTimeFieldType.dayOfMonth(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.year()});
        stdDateTimeFields = stdDateTimeFieldsBuilder.build();
    }

    public static class Timer {
        private final String name;
        private final ReadableInstant start = new Instant();
        @Nullable
        private Instant end;

        public Timer(String name) {
            this.name = name;
        }

        public ReadableDuration finish() {
            return new Duration(this.start(), this.end());
        }

        public ReadableDuration logFinish(Logger logger) {
            ReadableDuration duration = this.finish();
            logger.trc("%s finished after %s.", this.name, duration);
            return duration;
        }

        public ReadableInstant start() {
            return this.start;
        }

        public ReadableInstant end() {
            if (this.end == null) {
                DateUtils.removeTimer(this);
                this.end = new Instant();
            }
            return this.end;
        }
    }
}

