/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public abstract class EnumUtils {
    public static <T extends Enum<T>> T enumNamed(@Nonnull Class<T> type, @Nonnull String name) {
        return Enum.valueOf(type, name);
    }

    public static <T> T unsafeEnumNamed(@Nonnull Class<T> type, @Nonnull String name) {
        T obj = EnumUtils.enumNamed(type, name);
        return type.cast(obj);
    }

    public static <T extends Enum<T>> Class<T> checkEnum(@Nonnull Class<?> type) {
        Preconditions.checkArgument(type.isEnum(), "%s is not an enum.", type);
        return type;
    }

    public static <T extends Enum<T>> T min(@Nonnull T first, @Nonnull T second) {
        return first.ordinal() < second.ordinal() ? first : second;
    }

    public static <T extends Enum<T>> T max(@Nonnull T first, @Nonnull T second) {
        return first.ordinal() > second.ordinal() ? first : second;
    }
}

