/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.io.ByteSource;
import com.google.common.io.CharStreams;
import com.lyndir.lhunath.opal.system.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;

public abstract class IOUtils {
    static final Logger logger = Logger.get(IOUtils.class);
    private static final Pattern PATH_SEPARATORS = Pattern.compile("[\\\\/]+");

    public static ByteSource supply(byte[] supply) {
        return ByteSource.wrap(supply);
    }

    @Nullable
    public static ZipEntry getZipEntry(ZipFile zipFile, CharSequence zippedName) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!PATH_SEPARATORS.matcher(entry.getName()).replaceAll("/").equals(PATH_SEPARATORS.matcher(zippedName).replaceAll("/"))) continue;
            return entry;
        }
        return null;
    }

    public static String grep(Charset charset, String pattern, File file, int group) throws IOException {
        return IOUtils.grep(charset, Pattern.compile(pattern), file, group);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    public static String grep(Charset charset, Pattern pattern, File file, int group) throws IOException {
        File[] files = file.listFiles();
        if (files != null) {
            StringBuilder resultBuilder = new StringBuilder();
            for (File child : files) {
                resultBuilder.append(IOUtils.grep(charset, pattern, child, group));
            }
            return resultBuilder.toString();
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);){
            String string = IOUtils.grep(pattern, reader, group);
            return string;
        }
    }

    public static String grep(Pattern pattern, Readable reader, int group) throws IOException {
        StringBuilder resultBuilder = new StringBuilder();
        for (String line : CharStreams.readLines(reader)) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            resultBuilder.append(matcher.group(group)).append(System.lineSeparator());
        }
        return resultBuilder.toString();
    }
}

