/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lyndir.lhunath.opal.system.error.AlreadyCheckedException;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.NFunctionNN;
import com.lyndir.lhunath.opal.system.util.NNFunctionNN;
import com.lyndir.lhunath.opal.system.util.NNOperation;
import com.lyndir.lhunath.opal.system.util.NNSupplier;
import com.lyndir.lhunath.opal.system.util.NSupplier;
import com.lyndir.lhunath.opal.system.util.ObjectMeta;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import com.lyndir.lhunath.opal.system.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ObjectUtils {
    static final Logger logger = Logger.get(ObjectUtils.class);
    private static final Pattern NON_PRINTABLE = Pattern.compile("[^\\p{Print}]");
    private static final int MAX_DECODE_LENGTH = 100;
    private static final Map<ObjectMeta.For, ThreadLocal<Set<Integer>>> seen = Maps.newEnumMap(ObjectMeta.For.class);
    private static final int HASHCODE_PRIME = 524287;
    private static final Optional<Class<Object>> persistentCollectionType = TypeUtils.loadClass("org.hibernate.collection.PersistentCollection");
    private static final Pattern PACKAGE_NODE;
    private static final Pattern PACKAGE;

    public static <P, C extends P> boolean isEqual(@Nullable C subObject, @Nullable P superObject) {
        if (subObject == superObject) {
            return true;
        }
        if (subObject == null) {
            return false;
        }
        if (subObject.getClass().isArray()) {
            return Arrays.deepEquals(new Object[]{subObject}, new Object[]{superObject});
        }
        return subObject.equals(superObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String describe(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (Class.class.isInstance(o)) {
            Class type = (Class)o;
            return String.format("<C: %s>", PACKAGE_NODE.matcher(type.getName()).replaceAll("$1."));
        }
        if (byte[].class.isInstance(o)) {
            byte[] byteArray = (byte[])o;
            StringBuilder toString = new StringBuilder(String.format("<b[]: %dB, ", byteArray.length));
            CharBuffer decodedBytes = Charsets.UTF_8.decode(ByteBuffer.wrap(byteArray, 0, Math.min(byteArray.length, 100)));
            String stripped = NON_PRINTABLE.matcher(decodedBytes).replaceAll(".");
            toString.append(stripped);
            if (byteArray.length > 100) {
                toString.append("[...]");
            }
            return toString.append('>').toString();
        }
        if (char[].class.isInstance(o)) {
            char[] charArray = (char[])o;
            StringBuilder toString = new StringBuilder(String.format("<c[]: #%d, ", charArray.length));
            toString.append(charArray, 0, Math.min(charArray.length, 100));
            if (charArray.length > 100) {
                toString.append("[...]");
            }
            return toString.append('>').toString();
        }
        if (Object[].class.isInstance(o)) {
            return String.format("<O[]:%s>", Arrays.asList((Object[])o).toString());
        }
        if (o instanceof String) {
            return String.format("\"%s\"", o);
        }
        if (o instanceof Map) {
            StringBuilder description = new StringBuilder().append("<M:[");
            Object toString = o;
            synchronized (toString) {
                for (Map.Entry entry : ((Map)o).entrySet()) {
                    if (description.length() > 1) {
                        description.append("], [");
                    }
                    description.append(ObjectUtils.describe(entry.getKey())).append('=').append(ObjectUtils.describe(entry.getValue()));
                }
            }
            return description.append("]>").toString();
        }
        if (o instanceof Iterable) {
            Iterable collection = (Iterable)o;
            StringBuilder description = new StringBuilder().append('[');
            Iterable iterable = collection;
            synchronized (iterable) {
                for (Object entry : collection) {
                    if (description.length() > 1) {
                        description.append(", ");
                    }
                    description.append(ObjectUtils.describe(entry));
                }
            }
            return description.append(']').toString();
        }
        if (o instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)o;
            return String.format("<Cert: DN=%s, Issuer=%s>", x509Certificate.getSubjectX500Principal().getName(), x509Certificate.getIssuerX500Principal().getName());
        }
        return String.valueOf(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(final Object o) {
        StringBuilder toString = new StringBuilder("{");
        toString.append(PACKAGE.matcher(o.getClass().getName()).replaceFirst(""));
        int identityHashCode = System.identityHashCode(o);
        toString.append('[').append(identityHashCode).append(']');
        if (!seen.get((Object)ObjectMeta.For.toString).get().add(identityHashCode)) {
            return toString.append('}').toString();
        }
        try {
            toString.append((CharSequence)ObjectUtils.forEachFieldWithMeta(ObjectMeta.For.toString, o.getClass(), new NFunctionNN<TypeUtils.LastResult<Field, StringBuilder>, StringBuilder>(){

                @Override
                public StringBuilder apply(@Nonnull TypeUtils.LastResult<Field, StringBuilder> lastResult) {
                    Field field = lastResult.getCurrent();
                    StringBuilder fieldsString = lastResult.getLastResult();
                    assert (fieldsString != null);
                    if (!ObjectUtils.isValueAccessible(o)) {
                        return fieldsString;
                    }
                    String name = null;
                    ObjectMeta fieldMeta = field.getAnnotation(ObjectMeta.class);
                    if (fieldMeta != null) {
                        name = fieldMeta.name();
                    }
                    if (name == null || name.isEmpty()) {
                        name = field.getName();
                    }
                    if (fieldsString.length() == 0) {
                        fieldsString.append(": ");
                    } else {
                        fieldsString.append(", ");
                    }
                    try {
                        field.setAccessible(true);
                    }
                    catch (SecurityException ignored) {
                        // empty catch block
                    }
                    try {
                        fieldsString.append(name).append('=').append(ObjectUtils.describe(field.get(o)));
                    }
                    catch (Throwable t) {
                        logger.dbg(t, "Couldn't load value for field: %s, in object: 0x%x", field, System.identityHashCode(o));
                    }
                    return fieldsString;
                }
            }, new StringBuilder()));
        }
        finally {
            seen.get((Object)ObjectMeta.For.toString).get().remove(identityHashCode);
        }
        return toString.append('}').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hashCode(final Object o) {
        int identityHashCode = System.identityHashCode(o);
        logger.trc("%sHashCode for: %s (%d)", StringUtils.indent(seen.get((Object)ObjectMeta.For.hashCode).get().size()), o.getClass().getName(), identityHashCode);
        if (seen.get((Object)ObjectMeta.For.hashCode).get().contains(identityHashCode)) {
            logger.trc("%s- Detected cycle, returning identity.", StringUtils.indent(seen.get((Object)ObjectMeta.For.hashCode).get().size() + 1), identityHashCode);
            return identityHashCode;
        }
        try {
            seen.get((Object)ObjectMeta.For.hashCode).get().add(identityHashCode);
            int n = ObjectUtils.ifNotNullElse(ObjectUtils.forEachFieldWithMeta(ObjectMeta.For.hashCode, o.getClass(), new NFunctionNN<TypeUtils.LastResult<Field, Integer>, Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer apply(@Nonnull TypeUtils.LastResult<Field, Integer> lastResult) {
                    int hashCode;
                    Integer lastHashCode;
                    Field field;
                    block11: {
                        field = lastResult.getCurrent();
                        lastHashCode = lastResult.getLastResult();
                        if (lastHashCode == null) {
                            lastHashCode = 0;
                        }
                        Object value = null;
                        try {
                            field.setAccessible(true);
                            value = field.get(o);
                        }
                        catch (IllegalAccessException | SecurityException ignored) {
                            // empty catch block
                        }
                        hashCode = System.identityHashCode(value);
                        if (value != null && ObjectUtils.isValueAccessible(value)) {
                            try {
                                if (value instanceof Iterable) {
                                    ImmutableSortedSet.Builder hashCodes = ImmutableSortedSet.naturalOrder();
                                    Object object = value;
                                    synchronized (object) {
                                        for (Object o_ : (Iterable)value) {
                                            hashCodes.add((Object)ObjectUtils.hashCode(o_));
                                        }
                                    }
                                    hashCode = hashCodes.build().hashCode();
                                    break block11;
                                }
                                hashCode = value.hashCode();
                            }
                            catch (Throwable t) {
                                logger.dbg(t, "Couldn't load hashCode for: %s, value: %s.  Falling back to identity hashCode.", field, value);
                            }
                        }
                    }
                    int newHashCode = 524287 * lastHashCode + hashCode;
                    logger.trc("%s- %s=%d (hashCode -> %d)", StringUtils.indent(((Set)((ThreadLocal)seen.get((Object)ObjectMeta.For.hashCode)).get()).size()), field.getName(), hashCode, newHashCode);
                    return newHashCode;
                }
            }, null), new NNSupplier<Integer>(){

                @Override
                @Nonnull
                public Integer get() {
                    return o.hashCode();
                }
            });
            return n;
        }
        finally {
            seen.get((Object)ObjectMeta.For.hashCode).get().remove(identityHashCode);
        }
    }

    private static boolean isValueAccessible(Object object) {
        if (persistentCollectionType.isPresent() && persistentCollectionType.get().isInstance(object)) {
            try {
                if (!((Boolean)object.getClass().getMethod("wasInitialized", new Class[0]).invoke(object, new Object[0])).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new AlreadyCheckedException("Are you using an unsupported version of Hibernate?", e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(final @Nullable Object superObject, final @Nullable Object subObject) {
        if (superObject == subObject) {
            return true;
        }
        if (superObject == null || subObject == null) {
            return false;
        }
        if (!superObject.getClass().isAssignableFrom(subObject.getClass())) {
            return false;
        }
        int identityHashCode = System.identityHashCode(superObject);
        if (seen.get((Object)ObjectMeta.For.equals).get().contains(identityHashCode)) {
            return true;
        }
        try {
            seen.get((Object)ObjectMeta.For.equals).get().add(identityHashCode);
            boolean bl = ObjectUtils.ifNotNullElse(ObjectUtils.forEachFieldWithMeta(ObjectMeta.For.equals, superObject.getClass(), new NFunctionNN<TypeUtils.LastResult<Field, Boolean>, Boolean>(){

                @Override
                @Nonnull
                public Boolean apply(@Nonnull TypeUtils.LastResult<Field, Boolean> lastResult) {
                    if (Boolean.FALSE.equals(lastResult.getLastResult())) {
                        return Boolean.FALSE;
                    }
                    Field field = lastResult.getCurrent();
                    try {
                        field.setAccessible(true);
                    }
                    catch (SecurityException ignored) {
                        // empty catch block
                    }
                    Object superValue = null;
                    Object subValue = null;
                    try {
                        if (ObjectUtils.isValueAccessible(superObject)) {
                            superValue = field.get(superObject);
                        }
                    }
                    catch (Throwable t) {
                        logger.dbg(t, "Couldn't load value for field: %s, in object: %s", field, superObject);
                    }
                    try {
                        if (ObjectUtils.isValueAccessible(subObject)) {
                            subValue = field.get(subObject);
                        }
                    }
                    catch (Throwable t) {
                        logger.dbg(t, "Couldn't load value for field: %s, in object: %s", field, subObject);
                    }
                    return Objects.equal(superValue, subValue);
                }
            }, null), false);
            return bl;
        }
        finally {
            seen.get((Object)ObjectMeta.For.equals).get().remove(identityHashCode);
        }
    }

    @Nullable
    private static <R, T> R forEachFieldWithMeta(final ObjectMeta.For meta, Class<T> type, final NFunctionNN<TypeUtils.LastResult<Field, R>, R> function, @Nullable R firstResult) {
        return TypeUtils.forEachSuperTypeOf(type, new NFunctionNN<TypeUtils.LastResult<Class<?>, R>, R>(){

            @Override
            public R apply(@Nonnull TypeUtils.LastResult<Class<?>, R> lastTypeResult) {
                Class<?> subType = lastTypeResult.getCurrent();
                final boolean usedByType = ObjectUtils.usesMeta(meta, subType);
                return TypeUtils.forEachFieldOf(subType, new NFunctionNN<TypeUtils.LastResult<Field, R>, R>(){

                    @Override
                    @Nullable
                    public R apply(@Nonnull TypeUtils.LastResult<Field, R> input) {
                        boolean usedByField;
                        Field field = input.getCurrent();
                        Object result = input.getLastResult();
                        if (Modifier.isStatic(field.getModifiers())) {
                            return result;
                        }
                        if (field.isAnnotationPresent(ObjectMeta.class) ? !(usedByField = ObjectUtils.usesMeta(meta, field)) : !usedByType) {
                            return result;
                        }
                        return function.apply(new TypeUtils.LastResult(field, result));
                    }
                }, lastTypeResult.getLastResult(), false);
            }
        }, null, firstResult);
    }

    private static <T> boolean usesMeta(ObjectMeta.For meta, Class<T> type) {
        for (Map.Entry<Class<T>, Map<Class<T>, ObjectMeta>> annotationEntry : TypeUtils.getAnnotations(type, ObjectMeta.class).entrySet()) {
            Class<T> superType = annotationEntry.getKey();
            Map<Class<T>, ObjectMeta> superTypeAnnotations = annotationEntry.getValue();
            ObjectMeta superTypeAnnotation = superTypeAnnotations.get(superType);
            if (superTypeAnnotation != null) {
                if (superType != type && !superTypeAnnotation.inherited()) break;
                return ObjectUtils.usesMeta(meta, superTypeAnnotation);
            }
            for (ObjectMeta annotation : superTypeAnnotations.values()) {
                if (superType != type && !annotation.inherited() || !ObjectUtils.usesMeta(meta, annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean usesMeta(ObjectMeta.For meta, Field field) {
        return ObjectUtils.usesMeta(meta, field.getAnnotation(ObjectMeta.class));
    }

    private static boolean usesMeta(ObjectMeta.For meta, ObjectMeta metaAnnotation) {
        if (metaAnnotation == null) {
            return false;
        }
        ImmutableList<ObjectMeta.For> uses = ImmutableList.copyOf(metaAnnotation.useFor());
        ImmutableList<ObjectMeta.For> ignores = ImmutableList.copyOf(metaAnnotation.ignoreFor());
        if (ignores.contains((Object)ObjectMeta.For.all) || ignores.contains((Object)meta)) {
            return false;
        }
        return uses.contains((Object)ObjectMeta.For.all) || uses.contains((Object)meta);
    }

    @Nonnull
    public static <T> T ifNotNullElse(@Nullable T value, @Nonnull T nullValue) {
        if (value == null) {
            return Preconditions.checkNotNull(nullValue);
        }
        return value;
    }

    @Nullable
    public static <T> T ifNotNullElseNullable(@Nullable T value, @Nullable T nullValue) {
        if (value == null) {
            return nullValue;
        }
        return value;
    }

    @Nonnull
    public static <T> T ifNotNullElse(@Nullable T value, NNSupplier<T> nullValueSupplier) {
        if (value != null) {
            return value;
        }
        return Preconditions.checkNotNull(nullValueSupplier.get());
    }

    @Nullable
    public static <T> T ifNotNullElseNullable(@Nullable T value, NSupplier<T> nullValueSupplier) {
        if (value != null) {
            return value;
        }
        return nullValueSupplier.get();
    }

    public static <T> void ifNotNull(@Nullable T value, NNOperation<T> notNullOperation) {
        if (value != null) {
            notNullOperation.apply(value);
        }
    }

    @Nullable
    public static <F, T> T ifNotNull(@Nullable F from, NFunctionNN<F, T> notNullValueFunction) {
        if (from == null) {
            return null;
        }
        return notNullValueFunction.apply(from);
    }

    @Nonnull
    public static <F, T> T ifNotNullElse(@Nullable F from, NNFunctionNN<F, T> notNullValueFunction, @Nonnull T nullValue) {
        if (from == null) {
            return Preconditions.checkNotNull(nullValue);
        }
        return Preconditions.checkNotNull(notNullValueFunction.apply(from));
    }

    @Nullable
    public static <F, T> T ifNotNullElseNullable(@Nullable F from, NFunctionNN<F, T> notNullValueFunction, @Nullable T nullValue) {
        if (from == null) {
            return nullValue;
        }
        return notNullValueFunction.apply(from);
    }

    @Nonnull
    public static <T> T ifNotNull(@Nonnull Class<T> type, @Nullable T object) {
        return ObjectUtils.ifNotNullElse(type, object, null);
    }

    @Nonnull
    public static <T> T ifNotNullElse(@Nonnull Class<T> type, final @Nullable T object, final @Nullable Object nullValue) {
        return type.cast(TypeUtils.newProxyInstance(type, new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (object == null) {
                    return nullValue;
                }
                method.setAccessible(true);
                return method.invoke(object, args);
            }
        }));
    }

    @Nonnull
    public static <T> T ifType(final @Nonnull Class<T> type, final Object object) {
        return TypeUtils.newProxyInstance(type, new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (type.isInstance(object)) {
                    return method.invoke(object, args);
                }
                return null;
            }
        });
    }

    @Nonnull
    public static <T> T ifTypeElse(final @Nonnull Class<T> type, final Object object, final @Nonnull Object badTypeValue) {
        return type.cast(TypeUtils.newProxyInstance(type, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (type.isInstance(object)) {
                    return Preconditions.checkNotNull(method.invoke(object, args));
                }
                return badTypeValue;
            }
        }));
    }

    @Nonnull
    public static <T> T ifTypeElseNullable(final @Nonnull Class<T> type, final Object object, final @Nullable Object badTypeValue) {
        return type.cast(TypeUtils.newProxyInstance(type, new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (type.isInstance(object)) {
                    return Preconditions.checkNotNull(method.invoke(object, args));
                }
                return badTypeValue;
            }
        }));
    }

    static {
        for (ObjectMeta.For forMeta : ObjectMeta.For.values()) {
            seen.put(forMeta, new ThreadLocal<Set<Integer>>(){

                @Override
                protected Set<Integer> initialValue() {
                    return Sets.newHashSet();
                }
            });
        }
        PACKAGE_NODE = Pattern.compile("([^\\.])[^\\.]+\\.");
        PACKAGE = Pattern.compile(".*\\.");
    }
}

