/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.base.Function;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lyndir.lhunath.opal.system.util.ObjectUtils;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class StringUtils {
    private static final Pattern TLD = Pattern.compile("^.*?([^\\.]+\\.[^\\.]+)$");
    private static final Pattern TRAILING_SLASHES = Pattern.compile("/+$");
    private static final Pattern NON_FINAL_PATH = Pattern.compile("^.*/");

    public static String str(String messageFormat, Object ... args) {
        return MessageFormat.format(messageFormat, args);
    }

    public static String strf(String format, Object ... args) {
        return String.format(format, args);
    }

    public static String concat(String delimitor, String ... elements) {
        StringBuilder concatenation = new StringBuilder();
        for (String element : elements) {
            concatenation.append(element).append(delimitor);
        }
        return concatenation.substring(0, concatenation.length() - delimitor.length());
    }

    public static boolean isEmpty(@Nullable String data) {
        return data == null || data.isEmpty();
    }

    @Nullable
    public static String ltrim(@Nullable String source, @Nullable String trim) {
        if (source == null || trim == null) {
            return source == null ? null : source;
        }
        StringBuilder trimmed = new StringBuilder(source);
        while (trimmed.indexOf(trim) == 0) {
            trimmed.delete(0, trim.length());
        }
        return trimmed.toString();
    }

    @Nullable
    public static String rtrim(@Nullable String source, @Nullable String trim) {
        if (source == null || trim == null) {
            return source == null ? null : source;
        }
        StringBuilder trimmed = new StringBuilder(source);
        while (trimmed.indexOf(trim, trimmed.length() - trim.length()) == trimmed.length() - trim.length()) {
            trimmed.delete(trimmed.length() - trim.length(), trimmed.length());
        }
        return trimmed.toString();
    }

    @Nullable
    public static String trim(String source, String trim) {
        return StringUtils.rtrim(StringUtils.ltrim(source, trim), trim);
    }

    public static String shortUrl(URL home) {
        String shortHome = TLD.matcher(home.getHost()).replaceFirst("$1");
        String path = NON_FINAL_PATH.matcher(TRAILING_SLASHES.matcher(home.getPath()).replaceFirst("")).replaceFirst("");
        return String.format("%s:%s", shortHome, path);
    }

    public static String expand(String source, String keyPrefix, Function<String, String> keyToExpansion) {
        TreeMap<Integer, Integer> indexToEnds = Maps.newTreeMap();
        TreeMap<Integer, String> indexToExpansions = Maps.newTreeMap();
        Pattern keyPattern = Pattern.compile(String.format("%s\\{([^\\}:]*)(?::([^\\}]*))?\\}", Pattern.quote(keyPrefix)));
        Matcher matcher = keyPattern.matcher(source);
        while (matcher.find()) {
            int index = matcher.start();
            String key = matcher.group(1);
            String fallback = matcher.group(2);
            String value = keyToExpansion.apply(key);
            indexToEnds.put(index, matcher.end());
            indexToExpansions.put(index, Verify.verifyNotNull(ObjectUtils.ifNotNullElse(value, fallback), "No value for required expansion key: %s", key));
        }
        TreeSet<Integer> reverseIndexes = Sets.newTreeSet(Collections.reverseOrder());
        reverseIndexes.addAll(indexToExpansions.keySet());
        StringBuilder filtered = new StringBuilder(source);
        for (Integer index : reverseIndexes) {
            filtered.replace(index, (Integer)indexToEnds.get(index), (String)indexToExpansions.get(index));
        }
        return filtered.toString();
    }

    public static String indent(int indents) {
        return StringUtils.indent(indents, 4);
    }

    public static String indent(int indents, int size) {
        StringBuilder indent = new StringBuilder(indents * size);
        for (int i = 0; i < indents * size; ++i) {
            indent.append(' ');
        }
        return indent.toString();
    }

    public static String indent(int indents, int size, String message) {
        return StringUtils.indent(indents, size) + message;
    }

    public static String repeat(String s, int repeat) {
        StringBuilder repeatedString = new StringBuilder(repeat * s.length());
        for (int i = 0; i < repeat; ++i) {
            repeatedString.append(s);
        }
        return repeatedString.toString();
    }
}

