/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.lyndir.lhunath.opal.system.error.BreakException;
import com.lyndir.lhunath.opal.system.error.InternalInconsistencyException;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.NFunctionNN;
import com.lyndir.lhunath.opal.system.util.ObjectUtils;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public abstract class TypeUtils {
    static final Logger logger = Logger.get(TypeUtils.class);
    private static final Pattern FIRST_LETTER = Pattern.compile("(\\w)\\w{2,}\\.");
    private static final Pattern THROWS = Pattern.compile(" throws [^\\(\\)]*");
    private static final Objenesis objenesis = new ObjenesisStd();

    @Nonnull
    public static <T> Optional<Class<T>> loadClass(String typeName) {
        try {
            return Optional.of(Thread.currentThread().getContextClassLoader().loadClass(typeName));
        }
        catch (ClassNotFoundException e) {
            return Optional.absent();
        }
    }

    public static <T> Optional<T> newInstance(Class<? extends T> type) {
        try {
            return Optional.of(type.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException ignored) {
            return Optional.absent();
        }
    }

    public static <T> Optional<T> newInstance(String typeName) {
        Optional<Class<T>> type = TypeUtils.loadClass(typeName);
        if (!type.isPresent()) {
            return Optional.absent();
        }
        return TypeUtils.newInstance(type.get());
    }

    public static <T> T newProxyInstance(Class<? extends T> type, final InvocationHandler invocationHandler) {
        MethodInterceptor interceptor = new MethodInterceptor(){

            @Override
            public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
                return invocationHandler.invoke(o, method, objects);
            }
        };
        Enhancer enhancer = TypeUtils.newEnhancer(type);
        enhancer.setCallbackType(interceptor.getClass());
        Class mockClass = enhancer.createClass();
        Enhancer.registerCallbacks(mockClass, new Callback[]{interceptor});
        Factory mock = (Factory)objenesis.newInstance(mockClass);
        mock.getCallback(0);
        return type.cast(mock);
    }

    private static Enhancer newEnhancer(final Class<?> type) {
        return new Enhancer(){
            {
                this.setSuperclass(type);
            }

            @Override
            protected void filterConstructors(Class sc, List constructors) {
                CollectionUtils.filter(constructors, new VisibilityPredicate(sc, true));
            }
        };
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Class<?> type, Class<? extends A> annotationType) {
        A annotation = type.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> subType : type.getInterfaces()) {
            annotation = TypeUtils.findAnnotation(subType, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        if (type.getSuperclass() != null && (annotation = TypeUtils.findAnnotation(type.getSuperclass(), annotationType)) != null) {
            return annotation;
        }
        return null;
    }

    @Nonnull
    public static <A extends Annotation> Map<Class<?>, Map<Class<?>, A>> getAnnotations(Class<?> type, Class<? extends A> annotationType) {
        ImmutableMap.Builder<Class<?>, Map<Object, Object>> typeHierarchyAnnotations = ImmutableMap.builder();
        ImmutableMap.Builder<Class<?>, A> typeAnnotations = ImmutableMap.builder();
        A annotation = type.getAnnotation(annotationType);
        if (annotation != null) {
            typeAnnotations.put(type, annotation);
        }
        for (Class<?> typeInterface : type.getInterfaces()) {
            annotation = TypeUtils.findAnnotation(typeInterface, annotationType);
            if (annotation == null) continue;
            typeAnnotations.put(typeInterface, annotation);
        }
        typeHierarchyAnnotations.put(type, typeAnnotations.build());
        if (type.getSuperclass() != null) {
            typeHierarchyAnnotations.putAll(TypeUtils.getAnnotations(type.getSuperclass(), annotationType));
        }
        return typeHierarchyAnnotations.build();
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(Method method, Class<? extends A> annotationType) {
        A annotation = method.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Method superclassMethod = null;
        Class<?> superclass = method.getDeclaringClass();
        while ((superclass = superclass.getSuperclass()) != null) {
            try {
                superclassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException ignored) {}
        }
        if (superclassMethod == null) {
            return null;
        }
        return TypeUtils.findAnnotation(superclassMethod, annotationType);
    }

    public static <E> ImmutableList<Constructor<E>> findConstructors(Class<? extends E> type, Object ... args) {
        ImmutableList.Builder constructors = ImmutableList.builder();
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            boolean compatible;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            boolean bl = compatible = parameterTypes.length == args.length;
            if (!compatible) {
                logger.dbg("constructor: %s, not compatible in parameter length: %d != %d", constructor, parameterTypes.length, args.length);
                continue;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i].isInstance(args[i])) continue;
                logger.dbg("constructor: %s, not compatible in parameter type: !%s.isInstance(%s)", constructor, parameterTypes[i], args[i]);
                compatible = false;
                break;
            }
            if (!compatible) continue;
            constructors.add(constructor);
        }
        return constructors.build();
    }

    public static <E> Constructor<E> getConstructor(Class<? extends E> type, Object ... args) {
        ImmutableList<Constructor<E>> constructors = TypeUtils.findConstructors(type, args);
        if (constructors.isEmpty()) {
            throw new InternalInconsistencyException(StringUtils.strf("No constructors of type: %s, match argument types: %s", type, Lists.transform(Arrays.asList(args), new Function<Object, Object>(){

                @Override
                public Object apply(Object input) {
                    return input == null ? "<null>" : input.getClass();
                }
            })));
        }
        if (constructors.size() > 1) {
            throw new InternalInconsistencyException(StringUtils.strf("Multiple constructors of type: %s, match argument types: %s, candidates: %s", type, Lists.transform(Arrays.asList(args), new Function<Object, Object>(){

                @Override
                public Object apply(Object input) {
                    return input == null ? "<null>" : input.getClass();
                }
            }), constructors));
        }
        return (Constructor)constructors.get(0);
    }

    @Nullable
    public static <T, R> R forEachSuperTypeOf(@Nonnull Class<T> type, @Nullable NFunctionNN<LastResult<Class<?>, R>, R> typeFunction, @Nullable NFunctionNN<LastResult<Class<?>, R>, R> interfaceFunction, @Nullable R firstResult) {
        R lastResult = firstResult;
        try {
            for (Class<T> currentType = type; currentType != null; currentType = currentType.getSuperclass()) {
                if (typeFunction != null) {
                    lastResult = typeFunction.apply(new LastResult<Class<T>, R>(currentType, lastResult));
                }
                if (interfaceFunction == null) continue;
                for (Class<?> interfaceType : currentType.getInterfaces()) {
                    lastResult = interfaceFunction.apply(new LastResult(interfaceType, lastResult));
                }
            }
        }
        catch (BreakException e) {
            lastResult = e.getResult();
        }
        return lastResult;
    }

    @Nullable
    public static <T, R> R forEachFieldOf(Class<? extends T> type, final NFunctionNN<LastResult<Field, R>, R> function, @Nullable R firstResult, boolean descend) {
        NFunctionNN eachFieldFunction = new NFunctionNN<LastResult<Class<?>, R>, R>(){

            @Override
            @Nullable
            public R apply(@Nonnull LastResult<Class<?>, R> lastResult) {
                Object result = lastResult.getLastResult();
                try {
                    for (Field field : lastResult.getCurrent().getDeclaredFields()) {
                        if (field.isSynthetic() || Modifier.isStatic(field.getModifiers())) continue;
                        logger.trc("Iteration of %s: %s", lastResult.getCurrent(), field);
                        result = function.apply(new LastResult(field, result));
                    }
                }
                catch (BreakException e) {
                    result = e.getResult();
                }
                return result;
            }
        };
        if (descend) {
            return TypeUtils.forEachSuperTypeOf(type, eachFieldFunction, null, firstResult);
        }
        return (R)eachFieldFunction.apply(new LastResult<Class<? extends T>, R>(type, firstResult));
    }

    @Nullable
    public static Field findFirstField(final Object owner, final Object value) {
        return TypeUtils.forEachFieldOf(owner.getClass(), new NFunctionNN<LastResult<Field, Field>, Field>(){

            @Override
            public Field apply(@Nonnull LastResult<Field, Field> input) {
                try {
                    input.getCurrent().setAccessible(true);
                    if (ObjectUtils.equals(input.getCurrent().get(owner), value)) {
                        throw new BreakException(input.getCurrent());
                    }
                }
                catch (IllegalAccessException e) {
                    throw logger.bug(e);
                }
                return input.getLastResult();
            }
        }, null, true);
    }

    public static boolean hasAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return TypeUtils.findAnnotation(type, annotationType) != null;
    }

    public static String propertyName(Method method) {
        String methodName = method.getName();
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2) {
            methodName = methodName.substring(2);
        }
        return methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
    }

    public static String compressSignature(CharSequence signature) {
        String compressed = FIRST_LETTER.matcher(signature).replaceAll("$1~");
        return THROWS.matcher(compressed).replaceFirst("");
    }

    public static class LastResult<C, R> {
        private final C current;
        private final R lastResult;

        public LastResult(@Nonnull C current, @Nullable R lastResult) {
            this.current = current;
            this.lastResult = lastResult;
        }

        @Nonnull
        public C getCurrent() {
            return this.current;
        }

        @Nullable
        public R getLastResult() {
            return this.lastResult;
        }
    }
}

