/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.lyndir.lhunath.opal.system.wrapper.Desktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class UIUtils {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final Color LIGHT_RED = Color.decode("#FFDDDD");
    public static final Color LIGHT_GREEN = Color.decode("#DDFFDD");
    public static final Color LIGHT_BLUE = Color.decode("#DDDDFF");
    public static final Color LIGHT_YELLOW = Color.decode("#FFFFDD");
    public static final Color RED = Color.decode("#FF9999");
    public static final Color GREEN = Color.decode("#99FF99");
    public static final Color BLUE = Color.decode("#9999FF");
    public static final Color YELLOW = Color.decode("#FFFF99");
    public static final Color DARK_RED = Color.decode("#993333");
    public static final Color DARK_GREEN = Color.decode("#339933");
    public static final Color DARK_BLUE = Color.decode("#333399");
    public static final Color DARK_YELLOW = Color.decode("#999933");
    public static final Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

    public static double fontWidth(Graphics graphics, Font font, String str) {
        return graphics.getFontMetrics(font).getStringBounds(str, graphics).getWidth();
    }

    public static double fontHeight(Graphics graphics, Font font, String str) {
        return graphics.getFontMetrics(font).getStringBounds(str, graphics).getHeight();
    }

    public static Point2D gridAlign(Point2D point, double gridX, double gridY) {
        return new Point2D.Double((double)Math.round(point.getX() / gridX) * gridX, (double)Math.round(point.getY() / gridY) * gridY);
    }

    public static boolean isChild(Component child, Container parent) {
        if (child instanceof Container) {
            for (Component grandChild : ((Container)child).getComponents()) {
                if (child.equals(parent)) {
                    return true;
                }
                if (!UIUtils.isChild(grandChild, parent)) continue;
                return true;
            }
        }
        return false;
    }

    public static String colorToHex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Nullable
    public static Color setAlpha(@Nullable Color color, int alpha) {
        if (color == null) {
            return null;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static boolean isDesktopSupported() {
        try {
            return Desktop.isDesktopSupported();
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    public static boolean isBrowseSupported() {
        try {
            return UIUtils.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    public static boolean isMailSupported() {
        try {
            return UIUtils.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.MAIL);
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    public static boolean isOpenSupported() {
        try {
            return UIUtils.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    public static void setUIFont(Font font) {
        FontUIResource uiFont = new FontUIResource(font);
        UIManager.put("Label.font", uiFont);
        UIManager.put("TabbedPane.font", uiFont);
        UIManager.put("TextField.font", uiFont);
        UIManager.put("PasswordField.font", uiFont);
        UIManager.put("Button.font", uiFont);
        UIManager.put("RadioButton.font", uiFont);
        UIManager.put("CheckBox.font", uiFont);
        UIManager.put("ComboBox.font", uiFont);
        UIManager.put("Menu.font", uiFont);
        UIManager.put("List.font", uiFont);
        UIManager.put("ListBox.font", uiFont);
        UIManager.put("MenuItem.font", uiFont);
        UIManager.put("Panel.font", uiFont);
        UIManager.put("TitledBorder.font", uiFont);
    }

    @Nullable
    public static ImageIcon getIcon(String resource) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static Component createDebugLabel(String text) {
        JLabel label = new JLabel(text, 0);
        label.setBorder(BorderFactory.createLineBorder(RED));
        return label;
    }
}

