/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.lyndir.lhunath.opal.system.CodeUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;

public abstract class URLUtils {
    public static URL addParameter(URL url, String key, Object value) {
        try {
            return new URL(URLUtils.addParameter(url.toExternalForm(), key, value));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Bug.", e);
        }
    }

    public static String addParameter(String url, String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key to add to url can't be null");
        }
        StringBuilder urlString = new StringBuilder(url);
        if (url.contains("?")) {
            urlString.append('&');
        } else {
            urlString.append('?');
        }
        try {
            urlString.append(URLEncoder.encode(key, "UTF-8"));
            if (value != null) {
                urlString.append('=');
                urlString.append(URLEncoder.encode(value.toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 unsupported by VM", e);
        }
        return urlString.toString();
    }

    public static String concat(String ... paths) {
        String base;
        if (paths.length == 0) {
            return "";
        }
        String string = base = paths[0] == null ? "" : paths[0];
        if (paths.length == 1) {
            return base;
        }
        String[] otherPaths = new String[paths.length - 1];
        System.arraycopy(paths, 1, otherPaths, 0, paths.length - 1);
        String otherPathsGlued = URLUtils.concat(otherPaths);
        StringBuilder glued = new StringBuilder(base);
        glued.append(base.charAt(base.length() - 1) == '/' || otherPathsGlued.isEmpty() ? "" : Character.valueOf('/'));
        if (!otherPathsGlued.isEmpty()) {
            glued.append(otherPathsGlued.charAt(0) == '/' ? otherPathsGlued.substring(1) : otherPathsGlued);
        }
        return glued.toString();
    }

    public static URL newURL(String urlFormat, Object ... urlFormatArgs) {
        try {
            return new URL(MessageFormat.format(urlFormat, Collections2.transform(ImmutableList.copyOf(urlFormatArgs), new Function<Object, String>(){

                @Override
                public String apply(Object input) {
                    return CodeUtils.encodeURL(input == null ? "" : input.toString());
                }
            }).toArray()));
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate(e);
        }
    }

    public static URI newURI(String urlFormat, Object ... urlFormatArgs) {
        try {
            return URLUtils.newURL(urlFormat, urlFormatArgs).toURI();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate(e);
        }
    }

    public static URL newURL(URL baseURL, CharSequence relativeURLString) {
        try {
            return relativeURLString == null ? baseURL : new URL(baseURL, relativeURLString.toString());
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate(e);
        }
    }

    public static URI newURI(URL baseURL, CharSequence relativeURLString) {
        try {
            return URLUtils.newURL(baseURL, relativeURLString).toURI();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate(e);
        }
    }
}

