/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.util;

import com.lyndir.lhunath.opal.system.logging.Logger;
import java.io.File;
import java.util.regex.Pattern;

public class Utils {
    private static final Logger logger = Logger.get(Utils.class);
    public static final double GOLDEN = 0.618;
    public static final double GOLDEN_INV = 1.6181229773462784;
    private static final Pattern WINDOWS = Pattern.compile("Windows.*");
    private static final Pattern LINUX = Pattern.compile("Linux.*");
    private static final Pattern MACOS = Pattern.compile("Mac.*");
    private static final Pattern SUNOS = Pattern.compile("SunOS.*");

    public static void initNativeLibPath(String libName) {
        String libFileName = libName;
        if (WINDOWS.matcher(System.getProperty("os.name")).matches()) {
            libFileName = String.format("%s.dll", libName);
        } else if (LINUX.matcher(System.getProperty("os.name")).matches()) {
            libFileName = String.format("lib%s.so", libName);
        } else if (MACOS.matcher(System.getProperty("os.name")).matches()) {
            libFileName = String.format("lib%s.jnilib", libName);
        } else if (SUNOS.matcher(System.getProperty("os.name")).matches()) {
            libFileName = "x86".equals(System.getProperty("os.arch")) ? String.format("lib%s_sun_x86.so", libName) : String.format("lib%s_sun_sparc.so", libName);
        } else {
            logger.wrn("Unrecognised OS: %s", System.getProperty("os.name"));
        }
        File libFile = new File(String.format("lib/native/%s", libFileName));
        if (libFile.exists()) {
            logger.wrn("Native library %s not supported for your OS (%s).", libName, System.getProperty("os.name"));
        } else {
            System.setProperty("java.library.path", String.format("%s:%s", System.getProperty("java.library.path"), libFile.getParent()));
        }
    }
}

