/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.wrapper;

import com.lyndir.lhunath.opal.system.wrapper.Wrapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class Desktop
extends Wrapper {
    public static Desktop getDesktop() throws UnsupportedOperationException {
        return new Desktop(Desktop.invoke(Desktop.class, null, "getDesktop"));
    }

    public static boolean isDesktopSupported() {
        try {
            return (Boolean)Desktop.invoke(Desktop.class, null, "isDesktopSupported");
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean isSupported(Action action) {
        try {
            Object desktopAction = Desktop.mapEnumValue((Object)action, Desktop.getClass("java.awt.Desktop.Action"));
            return (Boolean)this.invoke("isSupported", new Class[]{Desktop.getClass("java.awt.Desktop.Action")}, desktopAction);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Desktop(Object wrappedInstance) {
        super(wrappedInstance);
    }

    public void browse(URI uri) throws NullPointerException, UnsupportedOperationException, IOException, SecurityException, IllegalArgumentException {
        this.invoke("browse", new Class[]{URI.class}, uri);
    }

    public void edit(File file) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        this.invoke("edit", new Class[]{File.class}, file);
    }

    public void mail() throws UnsupportedOperationException, IOException, SecurityException {
        this.invoke("mail");
    }

    public void mail(URI mailtoURI) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        this.invoke("mail", new Class[]{URI.class}, mailtoURI);
    }

    public void open(File file) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        this.invoke("open", new Class[]{File.class}, file);
    }

    public void print(File file) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        this.invoke("print", new Class[]{File.class}, file);
    }

    static {
        Desktop.initWrapper(Desktop.class, "java.awt.Desktop");
    }

    public static enum Action {
        BROWSE,
        EDIT,
        MAIL,
        OPEN,
        PRINT;

    }
}

