/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.wrapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Wrapper {
    static final Map<Class<? extends Wrapper>, Class<?>> wrappedClasses = new HashMap();
    static boolean classNotFound;
    @Nonnull
    protected final Object wrappedInstance;

    protected static Object construct(Class<? extends Wrapper> proxyClass, Class<?>[] classes, Object ... args) throws UnsupportedOperationException {
        try {
            Constructor<?> constructor = Wrapper.getWrappedClass(proxyClass).getConstructor(classes);
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected static Class<?> getWrappedClass(Class<? extends Wrapper> proxyClass) throws UnsupportedOperationException {
        try {
            if (classNotFound) {
                throw new ClassNotFoundException("Wrapper Class unavailable.");
            }
            if (!wrappedClasses.containsKey(proxyClass)) {
                throw new IllegalStateException("You did not initialize the wrapper for " + proxyClass.getName() + " yet!");
            }
            return wrappedClasses.get(proxyClass);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected static Class<?> getClass(String className) throws UnsupportedOperationException {
        try {
            return ClassLoader.getSystemClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected static boolean initWrapper(Class<? extends Wrapper> proxyClass, String wrappedClassName) {
        try {
            wrappedClasses.put(proxyClass, Wrapper.getClass(wrappedClassName));
            return true;
        }
        catch (UnsupportedOperationException ignored) {
            classNotFound = true;
            return false;
        }
    }

    protected static Object invoke(Class<? extends Wrapper> proxyClass, @Nullable Object wrappedInstance, String methodName) throws UnsupportedOperationException {
        return Wrapper.invoke(proxyClass, wrappedInstance, methodName, new Class[0], new Object[0]);
    }

    protected static Object invoke(Class<? extends Wrapper> proxyClass, @Nullable Object wrappedInstance, String methodName, Class<?>[] classes, Object ... args) throws UnsupportedOperationException {
        try {
            Method method = Wrapper.getWrappedClass(proxyClass).getMethod(methodName, classes);
            return method.invoke(wrappedInstance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Nullable
    protected static Object mapEnumValue(Object proxyEnum, Class<?> wrappedEnumClass) {
        for (Object wrappedEnum : wrappedEnumClass.getEnumConstants()) {
            if (!wrappedEnum.toString().equals(proxyEnum.toString())) continue;
            return wrappedEnum;
        }
        return null;
    }

    protected Wrapper(@Nonnull Object wrappedInstance) {
        this.wrappedInstance = wrappedInstance;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            return super.equals(obj);
        }
        if (obj.getClass().equals(this.wrappedInstance.getClass())) {
            return this.wrappedInstance.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.wrappedInstance.hashCode();
    }

    public String toString() {
        return this.wrappedInstance.toString();
    }

    @Nonnull
    protected Object getWrappedInstance() {
        return this.wrappedInstance;
    }

    protected Object invoke(String methodName) throws UnsupportedOperationException {
        return this.invoke(methodName, new Class[0], new Object[0]);
    }

    protected Object invoke(String methodName, Class<?>[] classes, Object ... args) throws UnsupportedOperationException {
        return Wrapper.invoke(this.getClass(), this.wrappedInstance, methodName, classes, args);
    }
}

