/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.google.common.base.Charsets;
import com.lyndir.lhunath.opal.system.MessageAuthenticationDigests;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class MPIdenticon {
    private static final Logger logger = Logger.get(MPIdenticon.class);
    private static final Charset charset = Charsets.UTF_8;
    private static final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.YELLOW, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.MONO};
    private static final char[] leftArm = new char[]{'\u2554', '\u255a', '\u2570', '\u2550'};
    private static final char[] rightArm = new char[]{'\u2557', '\u255d', '\u256f', '\u2550'};
    private static final char[] body = new char[]{'\u2588', '\u2591', '\u2592', '\u2593', '\u263a', '\u263b'};
    private static final char[] accessory = new char[]{'\u25c8', '\u25ce', '\u25d0', '\u25d1', '\u25d2', '\u25d3', '\u2600', '\u2601', '\u2602', '\u2603', '\u2604', '\u2605', '\u2606', '\u260e', '\u260f', '\u2388', '\u2302', '\u2618', '\u2622', '\u2623', '\u2615', '\u231a', '\u231b', '\u23f0', '\u26a1', '\u26c4', '\u26c5', '\u2614', '\u2654', '\u2655', '\u2656', '\u2657', '\u2658', '\u2659', '\u265a', '\u265b', '\u265c', '\u265d', '\u265e', '\u265f', '\u2668', '\u2669', '\u266a', '\u266b', '\u2690', '\u2691', '\u2694', '\u2696', '\u2699', '\u26a0', '\u2318', '\u23ce', '\u2704', '\u2706', '\u2708', '\u2709', '\u270c'};
    private final String fullName;
    private final Color color;
    private final String text;

    public MPIdenticon(String fullName, String masterPassword) {
        this(fullName, masterPassword.toCharArray());
    }

    public MPIdenticon(String fullName, char[] masterPassword) {
        this.fullName = fullName;
        byte[] masterPasswordBytes = charset.encode(CharBuffer.wrap(masterPassword)).array();
        ByteBuffer identiconSeedBytes = ByteBuffer.wrap(MessageAuthenticationDigests.HmacSHA256.of(masterPasswordBytes, fullName.getBytes(charset)));
        Arrays.fill(masterPasswordBytes, (byte)0);
        IntBuffer identiconSeedBuffer = IntBuffer.allocate(identiconSeedBytes.capacity());
        while (identiconSeedBytes.hasRemaining()) {
            identiconSeedBuffer.put(identiconSeedBytes.get() & 0xFF);
        }
        int[] identiconSeed = identiconSeedBuffer.array();
        this.color = colors[identiconSeed[4] % colors.length];
        this.text = StringUtils.strf("%c%c%c%c", Character.valueOf(leftArm[identiconSeed[0] % leftArm.length]), Character.valueOf(body[identiconSeed[1] % body.length]), Character.valueOf(rightArm[identiconSeed[2] % rightArm.length]), Character.valueOf(accessory[identiconSeed[3] % accessory.length]));
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getText() {
        return this.text;
    }

    public Color getColor() {
        return this.color;
    }

    public static enum Color {
        RED,
        GREEN,
        YELLOW,
        BLUE,
        MAGENTA,
        CYAN,
        MONO;

    }
}

