/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.masterpassword.MPSiteFeature;
import com.lyndir.masterpassword.MPSiteTypeClass;
import com.lyndir.masterpassword.MPTemplate;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public enum MPSiteType {
    GeneratedMaximum("20 characters, contains symbols.", ImmutableList.of("x", "max", "maximum"), ImmutableList.of(new MPTemplate("anoxxxxxxxxxxxxxxxxx"), new MPTemplate("axxxxxxxxxxxxxxxxxno")), MPSiteTypeClass.Generated, 0, new MPSiteFeature[0]),
    GeneratedLong("Copy-friendly, 14 characters, contains symbols.", ImmutableList.of("l", "long"), ImmutableList.of(new MPTemplate("CvcvnoCvcvCvcv"), new MPTemplate("CvcvCvcvnoCvcv"), new MPTemplate("CvcvCvcvCvcvno"), new MPTemplate("CvccnoCvcvCvcv"), new MPTemplate("CvccCvcvnoCvcv"), new MPTemplate("CvccCvcvCvcvno"), new MPTemplate("CvcvnoCvccCvcv"), new MPTemplate("CvcvCvccnoCvcv"), new MPTemplate("CvcvCvccCvcvno"), new MPTemplate("CvcvnoCvcvCvcc"), new MPTemplate("CvcvCvcvnoCvcc"), new MPTemplate("CvcvCvcvCvccno"), new MPTemplate[]{new MPTemplate("CvccnoCvccCvcv"), new MPTemplate("CvccCvccnoCvcv"), new MPTemplate("CvccCvccCvcvno"), new MPTemplate("CvcvnoCvccCvcc"), new MPTemplate("CvcvCvccnoCvcc"), new MPTemplate("CvcvCvccCvccno"), new MPTemplate("CvccnoCvcvCvcc"), new MPTemplate("CvccCvcvnoCvcc"), new MPTemplate("CvccCvcvCvccno")}), MPSiteTypeClass.Generated, 1, new MPSiteFeature[0]),
    GeneratedMedium("Copy-friendly, 8 characters, contains symbols.", ImmutableList.of("m", "med", "medium"), ImmutableList.of(new MPTemplate("CvcnoCvc"), new MPTemplate("CvcCvcno")), MPSiteTypeClass.Generated, 2, new MPSiteFeature[0]),
    GeneratedBasic("8 characters, no symbols.", ImmutableList.of("b", "basic"), ImmutableList.of(new MPTemplate("aaanaaan"), new MPTemplate("aannaaan"), new MPTemplate("aaannaaa")), MPSiteTypeClass.Generated, 3, new MPSiteFeature[0]),
    GeneratedShort("Copy-friendly, 4 characters, no symbols.", ImmutableList.of("s", "short"), ImmutableList.of(new MPTemplate("Cvcn")), MPSiteTypeClass.Generated, 4, new MPSiteFeature[0]),
    GeneratedPIN("4 numbers.", ImmutableList.of("i", "pin"), ImmutableList.of(new MPTemplate("nnnn")), MPSiteTypeClass.Generated, 5, new MPSiteFeature[0]),
    GeneratedName("9 letter name.", ImmutableList.of("n", "name"), ImmutableList.of(new MPTemplate("cvccvcvcv")), MPSiteTypeClass.Generated, 14, new MPSiteFeature[0]),
    GeneratedPhrase("20 character sentence.", ImmutableList.of("p", "phrase"), ImmutableList.of(new MPTemplate("cvcc cvc cvccvcv cvc"), new MPTemplate("cvc cvccvcvcv cvcv"), new MPTemplate("cv cvccv cvc cvcvccv")), MPSiteTypeClass.Generated, 15, new MPSiteFeature[0]),
    StoredPersonal("AES-encrypted, exportable.", ImmutableList.of("personal"), ImmutableList.of(), MPSiteTypeClass.Stored, 0, MPSiteFeature.ExportContent),
    StoredDevicePrivate("AES-encrypted, not exported.", ImmutableList.of("device"), ImmutableList.of(), MPSiteTypeClass.Stored, 1, MPSiteFeature.DevicePrivate);

    static final Logger logger;
    private final String description;
    private final List<String> options;
    private final List<MPTemplate> templates;
    private final MPSiteTypeClass typeClass;
    private final int typeIndex;
    private final Set<MPSiteFeature> typeFeatures;

    private MPSiteType(String description, List<String> options, List<MPTemplate> templates, MPSiteTypeClass typeClass, int typeIndex, MPSiteFeature ... typeFeatures) {
        this.description = description;
        this.options = options;
        this.templates = templates;
        this.typeClass = typeClass;
        this.typeIndex = typeIndex;
        ImmutableSet.Builder typeFeaturesBuilder = ImmutableSet.builder();
        for (MPSiteFeature typeFeature : typeFeatures) {
            typeFeaturesBuilder.add((Object)typeFeature);
        }
        this.typeFeatures = typeFeaturesBuilder.build();
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public MPSiteTypeClass getTypeClass() {
        return this.typeClass;
    }

    public Set<MPSiteFeature> getTypeFeatures() {
        return this.typeFeatures;
    }

    public int getType() {
        int mask = this.typeIndex | this.typeClass.getMask();
        for (MPSiteFeature typeFeature : this.typeFeatures) {
            mask |= typeFeature.getMask();
        }
        return mask;
    }

    public static MPSiteType forOption(String option) {
        for (MPSiteType type : MPSiteType.values()) {
            if (!type.getOptions().contains(option.toLowerCase())) continue;
            return type;
        }
        throw logger.bug("No type for option: %s", option);
    }

    @Contract(value="!null -> !null, null -> null")
    public static MPSiteType forName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (MPSiteType type : MPSiteType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        throw logger.bug("No type for name: %s", name);
    }

    public static ImmutableList<MPSiteType> forClass(MPSiteTypeClass typeClass) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (MPSiteType type : MPSiteType.values()) {
            if (type.getTypeClass() != typeClass) continue;
            types.add((Object)type);
        }
        return types.build();
    }

    public static MPSiteType forType(int type) {
        for (MPSiteType siteType : MPSiteType.values()) {
            if (siteType.getType() != type) continue;
            return siteType;
        }
        throw logger.bug("No type: %s", type);
    }

    public static ImmutableList<MPSiteType> forMask(int mask) {
        int typeMask = mask & 0xFFFFFFF0;
        ImmutableList.Builder types = ImmutableList.builder();
        for (MPSiteType siteType : MPSiteType.values()) {
            if ((siteType.getType() & 0xFFFFFFF0 & typeMask) == 0) continue;
            types.add((Object)siteType);
        }
        return types.build();
    }

    public MPTemplate getTemplateAtRollingIndex(int templateIndex) {
        return this.templates.get(templateIndex % this.templates.size());
    }

    static {
        logger = Logger.get(MPSiteType.class);
    }
}

