/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.google.common.collect.ImmutableList;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.masterpassword.MPSiteType;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public enum MPSiteVariant {
    Password("The password to log in with.", "Doesn't currently use a context.", ImmutableList.of("p", "password"), "com.lyndir.masterpassword"),
    Login("The username to log in as.", "Doesn't currently use a context.", ImmutableList.of("l", "login"), "com.lyndir.masterpassword.login"),
    Answer("The answer to a security question.", "Empty for a universal site answer or\nthe most significant word(s) of the question.", ImmutableList.of("a", "answer"), "com.lyndir.masterpassword.answer");

    static final Logger logger;
    private final String description;
    private final String contextDescription;
    private final List<String> options;
    private final String scope;

    private MPSiteVariant(String description, String contextDescription, List<String> options, String scope) {
        this.contextDescription = contextDescription;
        this.options = options;
        this.description = description;
        this.scope = scope;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContextDescription() {
        return this.contextDescription;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getScope() {
        return this.scope;
    }

    public static MPSiteVariant forOption(String option) {
        for (MPSiteVariant variant : MPSiteVariant.values()) {
            if (!variant.getOptions().contains(option.toLowerCase())) continue;
            return variant;
        }
        throw logger.bug("No variant for option: %s", option);
    }

    @Contract(value="!null -> !null, null -> null")
    public static MPSiteVariant forName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (MPSiteVariant type : MPSiteVariant.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        throw logger.bug("No variant for name: %s", name);
    }

    static {
        logger = Logger.get(MPSiteType.class);
    }
}

