/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.lyndir.lhunath.opal.system.logging.Logger;

public enum MPTemplateCharacterClass {
    UpperVowel('V', "AEIOU"),
    UpperConsonant('C', "BCDFGHJKLMNPQRSTVWXYZ"),
    LowerVowel('v', "aeiou"),
    LowerConsonant('c', "bcdfghjklmnpqrstvwxyz"),
    UpperAlphanumeric('A', "AEIOUBCDFGHJKLMNPQRSTVWXYZ"),
    Alphanumeric('a', "AEIOUaeiouBCDFGHJKLMNPQRSTVWXYZbcdfghjklmnpqrstvwxyz"),
    Numeric('n', "0123456789"),
    Other('o', "@&%?,=[]_:-+*$#!'^~;()/."),
    Any('x', "AEIOUaeiouBCDFGHJKLMNPQRSTVWXYZbcdfghjklmnpqrstvwxyz0123456789!@#$%^&*()"),
    Space(' ', " ");

    private static final Logger logger;
    private final char identifier;
    private final char[] characters;

    private MPTemplateCharacterClass(char identifier, String characters) {
        this.identifier = identifier;
        this.characters = characters.toCharArray();
    }

    public char getIdentifier() {
        return this.identifier;
    }

    public char getCharacterAtRollingIndex(int index) {
        return this.characters[index % this.characters.length];
    }

    public static MPTemplateCharacterClass forIdentifier(char identifier) {
        for (MPTemplateCharacterClass characterClass : MPTemplateCharacterClass.values()) {
            if (characterClass.getIdentifier() != identifier) continue;
            return characterClass;
        }
        throw logger.bug("No character class defined for identifier: %s", Character.valueOf(identifier));
    }

    static {
        logger = Logger.get(MPTemplateCharacterClass.class);
    }
}

