/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.google.common.base.Preconditions;
import com.lyndir.lhunath.opal.system.CodeUtils;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.masterpassword.MPSiteType;
import com.lyndir.masterpassword.MPSiteVariant;
import com.lyndir.masterpassword.MasterKeyV0;
import com.lyndir.masterpassword.MasterKeyV1;
import com.lyndir.masterpassword.MasterKeyV2;
import com.lyndir.masterpassword.MasterKeyV3;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class MasterKey {
    private static final Logger logger = Logger.get(MasterKey.class);
    @Nonnull
    private final String fullName;
    @Nullable
    private byte[] masterKey;

    public static MasterKey create(String fullName, char[] masterPassword) {
        return MasterKey.create(Version.CURRENT, fullName, masterPassword);
    }

    @Nonnull
    public static MasterKey create(Version version, String fullName, char[] masterPassword) {
        switch (version) {
            case V0: {
                return new MasterKeyV0(fullName).revalidate(masterPassword);
            }
            case V1: {
                return new MasterKeyV1(fullName).revalidate(masterPassword);
            }
            case V2: {
                return new MasterKeyV2(fullName).revalidate(masterPassword);
            }
            case V3: {
                return new MasterKeyV3(fullName).revalidate(masterPassword);
            }
        }
        throw new UnsupportedOperationException("Unsupported version: " + (Object)((Object)version));
    }

    protected MasterKey(@NotNull String fullName) {
        this.fullName = fullName;
        logger.trc("fullName: %s", fullName);
    }

    @Nullable
    protected abstract byte[] deriveKey(char[] var1);

    public abstract Version getAlgorithmVersion();

    @NotNull
    public String getFullName() {
        return this.fullName;
    }

    @Nonnull
    protected byte[] getKey() {
        Preconditions.checkState(this.isValid());
        return Preconditions.checkNotNull(this.masterKey);
    }

    public byte[] getKeyID() {
        return this.idForBytes(this.getKey());
    }

    public abstract String encode(@Nonnull String var1, MPSiteType var2, int var3, MPSiteVariant var4, @Nullable String var5);

    public boolean isValid() {
        return this.masterKey != null;
    }

    public void invalidate() {
        if (this.masterKey != null) {
            Arrays.fill(this.masterKey, (byte)0);
            this.masterKey = null;
        }
    }

    public MasterKey revalidate(char[] masterPassword) {
        this.invalidate();
        logger.trc("masterPassword: %s", new String(masterPassword));
        long start = System.currentTimeMillis();
        this.masterKey = this.deriveKey(masterPassword);
        if (this.masterKey == null) {
            logger.dbg("masterKey calculation failed after %.2fs.", (double)(System.currentTimeMillis() - start) / 1000.0);
        } else {
            logger.trc("masterKey ID: %s (derived in %.2fs)", CodeUtils.encodeHex(this.idForBytes(this.masterKey)), (double)(System.currentTimeMillis() - start) / 1000.0);
        }
        return this;
    }

    protected abstract byte[] bytesForInt(int var1);

    protected abstract byte[] idForBytes(byte[] var1);

    public static enum Version {
        V0,
        V1,
        V2,
        V3;

        public static final Version CURRENT;

        public static Version fromInt(int algorithmVersion) {
            return Version.values()[algorithmVersion];
        }

        public int toInt() {
            return this.ordinal();
        }

        public String toBundleVersion() {
            switch (this) {
                case V0: {
                    return "1.0";
                }
                case V1: {
                    return "2.0";
                }
                case V2: {
                    return "2.1";
                }
                case V3: {
                    return "2.2";
                }
            }
            throw new UnsupportedOperationException("Unsupported version: " + (Object)((Object)this));
        }

        static {
            CURRENT = V3;
        }
    }
}

