/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.lambdaworks.crypto.SCrypt;
import com.lyndir.lhunath.opal.system.CodeUtils;
import com.lyndir.lhunath.opal.system.MessageAuthenticationDigests;
import com.lyndir.lhunath.opal.system.MessageDigests;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.masterpassword.MPSiteType;
import com.lyndir.masterpassword.MPSiteTypeClass;
import com.lyndir.masterpassword.MPSiteVariant;
import com.lyndir.masterpassword.MPTemplate;
import com.lyndir.masterpassword.MPTemplateCharacterClass;
import com.lyndir.masterpassword.MasterKey;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class MasterKeyV0
extends MasterKey {
    private static final Logger logger = Logger.get(MasterKeyV0.class);
    protected final int MP_N = 32768;
    protected final int MP_r = 8;
    protected final int MP_p = 2;
    protected final int MP_dkLen = 64;
    protected final int MP_intLen = 32;
    protected final Charset MP_charset = Charsets.UTF_8;
    protected final ByteOrder MP_byteOrder = ByteOrder.BIG_ENDIAN;
    protected final MessageDigests MP_hash = MessageDigests.SHA256;
    protected final MessageAuthenticationDigests MP_mac = MessageAuthenticationDigests.HmacSHA256;

    public MasterKeyV0(String fullName) {
        super(fullName);
    }

    @Override
    public MasterKey.Version getAlgorithmVersion() {
        return MasterKey.Version.V0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected byte[] deriveKey(char[] masterPassword) {
        String fullName = this.getFullName();
        byte[] fullNameBytes = fullName.getBytes(this.MP_charset);
        byte[] fullNameLengthBytes = this.bytesForInt(fullName.length());
        String mpKeyScope = MPSiteVariant.Password.getScope();
        byte[] masterKeySalt = Bytes.concat(mpKeyScope.getBytes(this.MP_charset), fullNameLengthBytes, fullNameBytes);
        logger.trc("key scope: %s", mpKeyScope);
        logger.trc("masterKeySalt ID: %s", CodeUtils.encodeHex(this.idForBytes(masterKeySalt)));
        ByteBuffer mpBytesBuf = this.MP_charset.encode(CharBuffer.wrap(masterPassword));
        byte[] mpBytes = new byte[mpBytesBuf.remaining()];
        mpBytesBuf.get(mpBytes, 0, mpBytes.length);
        Arrays.fill(mpBytesBuf.array(), (byte)0);
        try {
            byte[] byArray = SCrypt.scrypt(mpBytes, masterKeySalt, 32768, 8, 2, 64);
            return byArray;
        }
        catch (GeneralSecurityException e) {
            logger.bug(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            Arrays.fill(mpBytes, (byte)0);
        }
    }

    @Override
    public String encode(String siteName, MPSiteType siteType, int siteCounter, MPSiteVariant siteVariant, @Nullable String siteContext) {
        Preconditions.checkArgument(siteType.getTypeClass() == MPSiteTypeClass.Generated);
        Preconditions.checkArgument(!siteName.isEmpty());
        logger.trc("siteName: %s", siteName);
        logger.trc("siteCounter: %d", siteCounter);
        logger.trc("siteVariant: %d (%s)", new Object[]{siteVariant.ordinal(), siteVariant});
        logger.trc("siteType: %d (%s)", new Object[]{siteType.ordinal(), siteType});
        if (siteCounter == 0) {
            siteCounter = (int)(System.currentTimeMillis() / 300000L) * 300;
        }
        String siteScope = siteVariant.getScope();
        byte[] siteNameBytes = siteName.getBytes(this.MP_charset);
        byte[] siteNameLengthBytes = this.bytesForInt(siteName.length());
        byte[] siteCounterBytes = this.bytesForInt(siteCounter);
        byte[] siteContextBytes = siteContext == null || siteContext.isEmpty() ? null : siteContext.getBytes(this.MP_charset);
        byte[] siteContextLengthBytes = this.bytesForInt(siteContextBytes == null ? 0 : siteContextBytes.length);
        logger.trc("site scope: %s, context: %s", siteScope, siteContextBytes == null ? "<empty>" : siteContext);
        logger.trc("seed from: hmac-sha256(masterKey, %s | %s | %s | %s | %s | %s)", siteScope, CodeUtils.encodeHex(siteNameLengthBytes), siteName, CodeUtils.encodeHex(siteCounterBytes), CodeUtils.encodeHex(siteContextLengthBytes), siteContextBytes == null ? "(null)" : siteContext);
        byte[] sitePasswordInfo = Bytes.concat(siteScope.getBytes(this.MP_charset), siteNameLengthBytes, siteNameBytes, siteCounterBytes);
        if (siteContextBytes != null) {
            sitePasswordInfo = Bytes.concat(sitePasswordInfo, siteContextLengthBytes, siteContextBytes);
        }
        logger.trc("sitePasswordInfo ID: %s", CodeUtils.encodeHex(this.idForBytes(sitePasswordInfo)));
        byte[] sitePasswordSeedBytes = this.MP_mac.of(this.getKey(), sitePasswordInfo);
        int[] sitePasswordSeed = new int[sitePasswordSeedBytes.length];
        for (int i = 0; i < sitePasswordSeedBytes.length; ++i) {
            ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
            Arrays.fill(buf.array(), sitePasswordSeedBytes[i] > 0 ? (byte)0 : -1);
            buf.position(2);
            buf.put(sitePasswordSeedBytes[i]).rewind();
            sitePasswordSeed[i] = buf.getInt() & 0xFFFF;
        }
        logger.trc("sitePasswordSeed ID: %s", CodeUtils.encodeHex(this.idForBytes(sitePasswordSeedBytes)));
        Preconditions.checkState(sitePasswordSeed.length > 0);
        int templateIndex = sitePasswordSeed[0];
        MPTemplate template = siteType.getTemplateAtRollingIndex(templateIndex);
        logger.trc("type %s, template: %s", new Object[]{siteType, template.getTemplateString()});
        StringBuilder password = new StringBuilder(template.length());
        for (int i = 0; i < template.length(); ++i) {
            int characterIndex = sitePasswordSeed[i + 1];
            MPTemplateCharacterClass characterClass = template.getCharacterClassAtIndex(i);
            char passwordCharacter = characterClass.getCharacterAtRollingIndex(characterIndex);
            logger.trc("class %c, index %d (0x%02X) -> character: %c", Character.valueOf(characterClass.getIdentifier()), characterIndex, sitePasswordSeed[i + 1], Character.valueOf(passwordCharacter));
            password.append(passwordCharacter);
        }
        return password.toString();
    }

    @Override
    protected byte[] bytesForInt(int integer) {
        return ByteBuffer.allocate(4).order(this.MP_byteOrder).putInt(integer).array();
    }

    @Override
    protected byte[] idForBytes(byte[] bytes) {
        return this.MP_hash.of(bytes);
    }
}

