/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.lyndir.lhunath.opal.system.CodeUtils;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.masterpassword.MPSiteType;
import com.lyndir.masterpassword.MPSiteTypeClass;
import com.lyndir.masterpassword.MPSiteVariant;
import com.lyndir.masterpassword.MPTemplate;
import com.lyndir.masterpassword.MPTemplateCharacterClass;
import com.lyndir.masterpassword.MasterKey;
import com.lyndir.masterpassword.MasterKeyV1;
import javax.annotation.Nullable;

public class MasterKeyV2
extends MasterKeyV1 {
    private static final Logger logger = Logger.get(MasterKeyV2.class);

    public MasterKeyV2(String fullName) {
        super(fullName);
    }

    @Override
    public MasterKey.Version getAlgorithmVersion() {
        return MasterKey.Version.V2;
    }

    @Override
    public String encode(String siteName, MPSiteType siteType, int siteCounter, MPSiteVariant siteVariant, @Nullable String siteContext) {
        Preconditions.checkArgument(siteType.getTypeClass() == MPSiteTypeClass.Generated);
        Preconditions.checkArgument(!siteName.isEmpty());
        logger.trc("siteName: %s", siteName);
        logger.trc("siteCounter: %d", siteCounter);
        logger.trc("siteVariant: %d (%s)", new Object[]{siteVariant.ordinal(), siteVariant});
        logger.trc("siteType: %d (%s)", new Object[]{siteType.ordinal(), siteType});
        if (siteCounter == 0) {
            siteCounter = (int)(System.currentTimeMillis() / 300000L) * 300;
        }
        String siteScope = siteVariant.getScope();
        byte[] siteNameBytes = siteName.getBytes(this.MP_charset);
        byte[] siteNameLengthBytes = this.bytesForInt(siteNameBytes.length);
        byte[] siteCounterBytes = this.bytesForInt(siteCounter);
        byte[] siteContextBytes = siteContext == null || siteContext.isEmpty() ? null : siteContext.getBytes(this.MP_charset);
        byte[] siteContextLengthBytes = this.bytesForInt(siteContextBytes == null ? 0 : siteContextBytes.length);
        logger.trc("site scope: %s, context: %s", siteScope, siteContextBytes == null ? "<empty>" : siteContext);
        logger.trc("seed from: hmac-sha256(masterKey, %s | %s | %s | %s | %s | %s)", siteScope, CodeUtils.encodeHex(siteNameLengthBytes), siteName, CodeUtils.encodeHex(siteCounterBytes), CodeUtils.encodeHex(siteContextLengthBytes), siteContextBytes == null ? "(null)" : siteContext);
        byte[] sitePasswordInfo = Bytes.concat(siteScope.getBytes(this.MP_charset), siteNameLengthBytes, siteNameBytes, siteCounterBytes);
        if (siteContextBytes != null) {
            sitePasswordInfo = Bytes.concat(sitePasswordInfo, siteContextLengthBytes, siteContextBytes);
        }
        logger.trc("sitePasswordInfo ID: %s", CodeUtils.encodeHex(this.idForBytes(sitePasswordInfo)));
        byte[] sitePasswordSeed = this.MP_mac.of(this.getKey(), sitePasswordInfo);
        logger.trc("sitePasswordSeed ID: %s", CodeUtils.encodeHex(this.idForBytes(sitePasswordSeed)));
        Preconditions.checkState(sitePasswordSeed.length > 0);
        int templateIndex = sitePasswordSeed[0] & 0xFF;
        MPTemplate template = siteType.getTemplateAtRollingIndex(templateIndex);
        logger.trc("type %s, template: %s", new Object[]{siteType, template.getTemplateString()});
        StringBuilder password = new StringBuilder(template.length());
        for (int i = 0; i < template.length(); ++i) {
            int characterIndex = sitePasswordSeed[i + 1] & 0xFF;
            MPTemplateCharacterClass characterClass = template.getCharacterClassAtIndex(i);
            char passwordCharacter = characterClass.getCharacterAtRollingIndex(characterIndex);
            logger.trc("class %c, index %d (0x%02X) -> character: %c", Character.valueOf(characterClass.getIdentifier()), characterIndex, sitePasswordSeed[i + 1], Character.valueOf(passwordCharacter));
            password.append(passwordCharacter);
        }
        return password.toString();
    }
}

