/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword;

import com.google.common.primitives.Bytes;
import com.lambdaworks.crypto.SCrypt;
import com.lyndir.lhunath.opal.system.CodeUtils;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.masterpassword.MPSiteVariant;
import com.lyndir.masterpassword.MasterKey;
import com.lyndir.masterpassword.MasterKeyV2;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class MasterKeyV3
extends MasterKeyV2 {
    private static final Logger logger = Logger.get(MasterKeyV3.class);

    public MasterKeyV3(String fullName) {
        super(fullName);
    }

    @Override
    public MasterKey.Version getAlgorithmVersion() {
        return MasterKey.Version.V3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected byte[] deriveKey(char[] masterPassword) {
        byte[] fullNameBytes = this.getFullName().getBytes(this.MP_charset);
        byte[] fullNameLengthBytes = this.bytesForInt(fullNameBytes.length);
        String mpKeyScope = MPSiteVariant.Password.getScope();
        byte[] masterKeySalt = Bytes.concat(mpKeyScope.getBytes(this.MP_charset), fullNameLengthBytes, fullNameBytes);
        logger.trc("key scope: %s", mpKeyScope);
        logger.trc("masterKeySalt ID: %s", CodeUtils.encodeHex(this.idForBytes(masterKeySalt)));
        ByteBuffer mpBytesBuf = this.MP_charset.encode(CharBuffer.wrap(masterPassword));
        byte[] mpBytes = new byte[mpBytesBuf.remaining()];
        mpBytesBuf.get(mpBytes, 0, mpBytes.length);
        Arrays.fill(mpBytesBuf.array(), (byte)0);
        try {
            byte[] byArray = SCrypt.scrypt(mpBytes, masterKeySalt, 32768, 8, 2, 64);
            return byArray;
        }
        catch (GeneralSecurityException e) {
            logger.bug(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            Arrays.fill(mpBytes, (byte)0);
        }
    }
}

