/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.google.common.collect.ImmutableList;
import com.lyndir.masterpassword.gui.Res;
import com.lyndir.masterpassword.gui.UnlockFrame;
import com.lyndir.masterpassword.gui.User;
import com.lyndir.masterpassword.gui.util.Components;
import java.awt.Component;
import java.awt.Dimension;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AuthenticationPanel
extends Components.GradientPanel {
    protected final UnlockFrame unlockFrame;
    protected final JLabel avatarLabel;

    public AuthenticationPanel(UnlockFrame unlockFrame) {
        super(null, null);
        this.unlockFrame = unlockFrame;
        this.setLayout(new BoxLayout(this, 3));
        this.add(Box.createVerticalGlue());
        this.avatarLabel = new JLabel(Res.avatar(0)){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
        this.add(this.avatarLabel);
        this.add(Box.createVerticalGlue());
        this.avatarLabel.setToolTipText("The avatar for your user.  Click to change it.");
    }

    protected void updateUser(boolean repack) {
        this.unlockFrame.updateUser(this.getSelectedUser());
        this.validate();
        if (repack) {
            this.unlockFrame.repack();
        }
    }

    @Nullable
    protected abstract User getSelectedUser();

    @Nonnull
    @NotNull
    public abstract char[] getMasterPassword();

    public Component getFocusComponent() {
        return null;
    }

    public Iterable<? extends JButton> getButtons() {
        return ImmutableList.of();
    }

    public abstract void reset();
}

