/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.TypeUtils;
import com.lyndir.masterpassword.gui.Config;
import com.lyndir.masterpassword.gui.PasswordFrame;
import com.lyndir.masterpassword.gui.UnlockFrame;
import com.lyndir.masterpassword.gui.User;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class GUI
implements UnlockFrame.SignInCallback {
    private static final Logger logger = Logger.get(GUI.class);
    private final UnlockFrame unlockFrame = new UnlockFrame(this);
    private PasswordFrame passwordFrame;

    public static void main(String[] args) throws IOException {
        if (Config.get().checkForUpdates()) {
            GUI.checkUpdate();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        TypeUtils.newInstance("com.lyndir.masterpassword.gui.platform.mac.AppleGUI").or(new GUI()).open();
    }

    private static void checkUpdate() {
        try {
            Enumeration<URL> manifestURLs = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifestURLs.hasMoreElements()) {
                InputStream manifestStream = manifestURLs.nextElement().openStream();
                Attributes attributes = new Manifest(manifestStream).getMainAttributes();
                if (!GUI.class.getCanonicalName().equals(attributes.getValue(Attributes.Name.MAIN_CLASS))) continue;
                String manifestRevision = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                String upstreamRevisionURL = "http://masterpasswordapp.com/masterpassword-gui.jar.rev";
                CharSource upstream = Resources.asCharSource(URI.create(upstreamRevisionURL).toURL(), Charsets.UTF_8);
                String upstreamRevision = upstream.readFirstLine();
                logger.inf("Local Revision:    <%s>", manifestRevision);
                logger.inf("Upstream Revision: <%s>", upstreamRevision);
                if (manifestRevision == null || manifestRevision.equalsIgnoreCase(upstreamRevision)) continue;
                logger.wrn("You are not running the current official version.  Please update from:\nhttp://masterpasswordapp.com/masterpassword-gui.jar", new Object[0]);
                JOptionPane.showMessageDialog(null, "A new version of Master Password is available.\nPlease download the latest version from http://masterpasswordapp.com", "Update Available", 2);
            }
        }
        catch (IOException e) {
            logger.wrn(e, "Couldn't check for version update.", new Object[0]);
        }
    }

    protected void open() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GUI.this.passwordFrame == null) {
                    GUI.this.unlockFrame.setVisible(true);
                } else {
                    GUI.this.passwordFrame.setVisible(true);
                }
            }
        });
    }

    @Override
    public void signedIn(User user) {
        this.passwordFrame = this.newPasswordFrame(user);
        this.open();
    }

    protected PasswordFrame newPasswordFrame(User user) {
        return new PasswordFrame(user);
    }
}

