/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.lyndir.masterpassword.gui.AuthenticationPanel;
import com.lyndir.masterpassword.gui.IncognitoUser;
import com.lyndir.masterpassword.gui.Res;
import com.lyndir.masterpassword.gui.UnlockFrame;
import com.lyndir.masterpassword.gui.User;
import com.lyndir.masterpassword.gui.util.Components;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class IncognitoAuthenticationPanel
extends AuthenticationPanel
implements DocumentListener,
ActionListener {
    private final JTextField fullNameField;
    private final JPasswordField masterPasswordField;

    public IncognitoAuthenticationPanel(UnlockFrame unlockFrame) {
        super(unlockFrame);
        this.add(Components.stud());
        JLabel fullNameLabel = Components.label("Full Name:");
        this.add(fullNameLabel);
        this.fullNameField = Components.textField();
        this.fullNameField.setFont(Res.valueFont().deriveFont(12.0f));
        this.fullNameField.getDocument().addDocumentListener(this);
        this.fullNameField.addActionListener(this);
        this.add(this.fullNameField);
        this.add(Components.stud());
        JLabel masterPasswordLabel = Components.label("Master Password:");
        this.add(masterPasswordLabel);
        this.masterPasswordField = Components.passwordField();
        this.masterPasswordField.addActionListener(this);
        this.masterPasswordField.getDocument().addDocumentListener(this);
        this.add(this.masterPasswordField);
    }

    @Override
    public Component getFocusComponent() {
        return this.fullNameField;
    }

    @Override
    public void reset() {
        this.masterPasswordField.setText("");
    }

    @Override
    protected User getSelectedUser() {
        return new IncognitoUser(this.fullNameField.getText());
    }

    @Override
    @NotNull
    public char[] getMasterPassword() {
        return this.masterPasswordField.getPassword();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateUser(false);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateUser(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateUser(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateUser(false);
        this.unlockFrame.trySignIn(this.fullNameField, this.masterPasswordField);
    }
}

