/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import com.lyndir.masterpassword.gui.AuthenticationPanel;
import com.lyndir.masterpassword.gui.ModelUser;
import com.lyndir.masterpassword.gui.Res;
import com.lyndir.masterpassword.gui.UnlockFrame;
import com.lyndir.masterpassword.gui.util.Components;
import com.lyndir.masterpassword.model.MPUser;
import com.lyndir.masterpassword.model.MPUserFileManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.annotation.Nullable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import org.jetbrains.annotations.NotNull;

public class ModelAuthenticationPanel
extends AuthenticationPanel
implements ItemListener,
ActionListener,
DocumentListener {
    private static final Logger logger = Logger.get(ModelAuthenticationPanel.class);
    private final JComboBox<ModelUser> userField;
    private final JLabel masterPasswordLabel;
    private final JPasswordField masterPasswordField;

    public ModelAuthenticationPanel(UnlockFrame unlockFrame) {
        super(unlockFrame);
        this.add(Components.stud());
        this.avatarLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModelUser selectedUser = ModelAuthenticationPanel.this.getSelectedUser();
                if (selectedUser != null) {
                    selectedUser.setAvatar(selectedUser.getAvatar() + 1);
                    ModelAuthenticationPanel.this.updateUser(false);
                }
            }
        });
        JLabel userLabel = Components.label("User:");
        this.add(userLabel);
        this.userField = Components.comboBox(this.readConfigUsers());
        this.userField.setFont(Res.valueFont().deriveFont(12.0f));
        this.userField.addItemListener(this);
        this.userField.addActionListener(this);
        this.userField.setEditor(new MetalComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                JTextField editorComponents = Components.textField();
                editorComponents.setForeground(Color.red);
                return editorComponents;
            }
        });
        this.add(this.userField);
        this.add(Components.stud());
        this.masterPasswordLabel = Components.label("Master Password:");
        this.add(this.masterPasswordLabel);
        this.masterPasswordField = Components.passwordField();
        this.masterPasswordField.addActionListener(this);
        this.masterPasswordField.getDocument().addDocumentListener(this);
        this.add(this.masterPasswordField);
    }

    @Override
    public Component getFocusComponent() {
        return this.masterPasswordField.isVisible() ? this.masterPasswordField : null;
    }

    @Override
    protected void updateUser(boolean repack) {
        ModelUser selectedUser = this.getSelectedUser();
        if (selectedUser != null) {
            boolean showPasswordField;
            this.avatarLabel.setIcon(Res.avatar(selectedUser.getAvatar()));
            boolean bl = showPasswordField = !selectedUser.keySaved();
            if (this.masterPasswordField.isVisible() != showPasswordField) {
                this.masterPasswordLabel.setVisible(showPasswordField);
                this.masterPasswordField.setVisible(showPasswordField);
                repack = true;
            }
        }
        super.updateUser(repack);
    }

    @Override
    protected ModelUser getSelectedUser() {
        int selectedIndex = this.userField.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return (ModelUser)this.userField.getModel().getElementAt(selectedIndex);
    }

    @Override
    @NotNull
    public char[] getMasterPassword() {
        return this.masterPasswordField.getPassword();
    }

    @Override
    public Iterable<? extends JButton> getButtons() {
        return ImmutableList.of(new JButton(Res.iconAdd()){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String fullName = JOptionPane.showInputDialog(ModelAuthenticationPanel.this, "Enter your full name, ensuring it is correctly spelled and capitalized:", "New User", 3);
                        MPUserFileManager.get().addUser(new MPUser(fullName));
                        ModelAuthenticationPanel.this.userField.setModel(new DefaultComboBoxModel<ModelUser>(ModelAuthenticationPanel.this.readConfigUsers()));
                        ModelAuthenticationPanel.this.updateUser(true);
                    }
                });
                this.setToolTipText("Add a new user to the list.");
            }
        }, new JButton(Res.iconDelete()){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelUser deleteUser = ModelAuthenticationPanel.this.getSelectedUser();
                        if (deleteUser == null) {
                            return;
                        }
                        if (JOptionPane.showConfirmDialog(ModelAuthenticationPanel.this, StringUtils.strf("Are you sure you want to delete the user and sites remembered for:\n%s.", deleteUser.getFullName()), "Delete User", 2, 3) == 2) {
                            return;
                        }
                        MPUserFileManager.get().deleteUser(deleteUser.getModel());
                        ModelAuthenticationPanel.this.userField.setModel(new DefaultComboBoxModel<ModelUser>(ModelAuthenticationPanel.this.readConfigUsers()));
                        ModelAuthenticationPanel.this.updateUser(true);
                    }
                });
                this.setToolTipText("Delete the selected user.");
            }
        }, new JButton(Res.iconQuestion()){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane.showMessageDialog(ModelAuthenticationPanel.this, StringUtils.strf("Reads users and sites from the directory at:\n%s", MPUserFileManager.get().getPath().getAbsolutePath()), "Help", 1);
                    }
                });
                this.setToolTipText("More information.");
            }
        });
    }

    @Override
    public void reset() {
        this.masterPasswordField.setText("");
    }

    private ModelUser[] readConfigUsers() {
        return FluentIterable.from(MPUserFileManager.get().getUsers()).transform(new Function<MPUser, ModelUser>(){

            @Override
            @Nullable
            public ModelUser apply(@Nullable MPUser model) {
                return new ModelUser(Preconditions.checkNotNull(model));
            }
        }).toArray(ModelUser.class);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateUser(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateUser(false);
        this.unlockFrame.trySignIn(this.userField);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateUser(false);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateUser(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateUser(false);
    }
}

