/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.lyndir.masterpassword.gui.ModelSite;
import com.lyndir.masterpassword.gui.Res;
import com.lyndir.masterpassword.gui.Site;
import com.lyndir.masterpassword.gui.User;
import com.lyndir.masterpassword.model.IncorrectMasterPasswordException;
import com.lyndir.masterpassword.model.MPSite;
import com.lyndir.masterpassword.model.MPSiteResult;
import com.lyndir.masterpassword.model.MPUser;
import com.lyndir.masterpassword.model.MPUserFileManager;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ModelUser
extends User {
    private final MPUser model;
    @Nullable
    private char[] masterPassword;

    public ModelUser(MPUser model) {
        this.model = model;
    }

    public MPUser getModel() {
        return this.model;
    }

    @Override
    public String getFullName() {
        return this.model.getFullName();
    }

    @Override
    @Nullable
    protected char[] getMasterPassword() {
        return this.masterPassword;
    }

    @Override
    public int getAvatar() {
        return this.model.getAvatar();
    }

    public void setAvatar(int avatar) {
        this.model.setAvatar(avatar % Res.avatars());
        MPUserFileManager.get().save();
    }

    @Override
    public void authenticate(char[] masterPassword) throws IncorrectMasterPasswordException {
        this.putKey(this.model.authenticate(masterPassword));
        this.masterPassword = masterPassword;
        MPUserFileManager.get().save();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.masterPassword != null) {
            Arrays.fill(this.masterPassword, '\u0000');
            this.masterPassword = null;
        }
    }

    @Override
    public Iterable<Site> findSitesByName(String query) {
        return FluentIterable.from(this.model.findSitesByName(query)).transform(new Function<MPSiteResult, Site>(){

            @Override
            @Nullable
            public Site apply(@Nullable MPSiteResult site) {
                return new ModelSite(Preconditions.checkNotNull(site));
            }
        });
    }

    @Override
    public void addSite(Site site) {
        this.model.addSite(new MPSite(this.model, site.getSiteName(), site.getSiteType(), site.getSiteCounter()));
        this.model.updateLastUsed();
        MPUserFileManager.get().save();
    }

    @Override
    public void deleteSite(Site site) {
        if (site instanceof ModelSite) {
            this.model.deleteSite(((ModelSite)site).getModel());
            MPUserFileManager.get().save();
        }
    }

    public boolean keySaved() {
        return false;
    }
}

