/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.lyndir.lhunath.opal.system.util.PredicateNN;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import com.lyndir.masterpassword.MPSiteType;
import com.lyndir.masterpassword.MPSiteTypeClass;
import com.lyndir.masterpassword.MPSiteVariant;
import com.lyndir.masterpassword.MasterKey;
import com.lyndir.masterpassword.gui.IncognitoSite;
import com.lyndir.masterpassword.gui.ModelSite;
import com.lyndir.masterpassword.gui.ModelUser;
import com.lyndir.masterpassword.gui.Res;
import com.lyndir.masterpassword.gui.Site;
import com.lyndir.masterpassword.gui.User;
import com.lyndir.masterpassword.gui.util.Components;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PasswordFrame
extends JFrame
implements DocumentListener {
    private final User user;
    private final Components.GradientPanel root;
    private final JTextField siteNameField;
    private final JButton siteActionButton;
    private final JComboBox<MPSiteType> siteTypeField;
    private final JComboBox<MasterKey.Version> siteVersionField;
    private final JSpinner siteCounterField;
    private final JPasswordField passwordField;
    private final JLabel tipLabel;
    private final JCheckBox maskPasswordField;
    private final char passwordEchoChar;
    private final Font passwordEchoFont;
    @Nullable
    private Site currentSite;
    private boolean updatingUI;

    public PasswordFrame(User user) throws HeadlessException {
        super("Master Password");
        this.user = user;
        this.setDefaultCloseOperation(2);
        this.root = Components.gradientPanel(new FlowLayout(), Res.colors().frameBg());
        this.setContentPane(this.root);
        this.root.setLayout(new BoxLayout(this.root, 3));
        this.root.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        Components.GradientPanel sitePanel = Components.boxLayout(3, new Component[0]);
        sitePanel.setOpaque(true);
        sitePanel.setBackground(Res.colors().controlBg());
        sitePanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.root.add(Components.borderPanel(sitePanel, BorderFactory.createRaisedBevelBorder(), Res.colors().frameBg()));
        sitePanel.add(Components.label(StringUtils.strf("Generating passwords for: %s", user.getFullName()), 0));
        sitePanel.add(Components.stud());
        sitePanel.add(Components.label("Site Name:"));
        Component[] componentArray = new Component[3];
        this.siteNameField = Components.textField();
        componentArray[0] = this.siteNameField;
        componentArray[1] = Components.stud();
        this.siteActionButton = Components.button("Add Site");
        componentArray[2] = this.siteActionButton;
        Components.GradientPanel siteControls = Components.boxLayout(2, componentArray);
        this.siteNameField.getDocument().addDocumentListener(this);
        this.siteNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Futures.addCallback(PasswordFrame.this.updatePassword(true), new FutureCallback<String>(){

                    @Override
                    public void onSuccess(@Nullable String sitePassword) {
                        StringSelection clipboardContents = new StringSelection(sitePassword);
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(clipboardContents, null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PasswordFrame.this.passwordField.setText(null);
                                PasswordFrame.this.siteNameField.setText(null);
                                PasswordFrame.this.dispatchEvent(new WindowEvent(PasswordFrame.this, 201));
                            }
                        });
                    }

                    @Override
                    public void onFailure(Throwable t) {
                    }
                });
            }
        });
        this.siteActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordFrame.this.currentSite == null) {
                    return;
                }
                if (PasswordFrame.this.currentSite instanceof ModelSite) {
                    PasswordFrame.this.user.deleteSite(PasswordFrame.this.currentSite);
                } else {
                    PasswordFrame.this.user.addSite(PasswordFrame.this.currentSite);
                }
                PasswordFrame.this.siteNameField.requestFocus();
                PasswordFrame.this.updatePassword(true);
            }
        });
        sitePanel.add(siteControls);
        sitePanel.add(Components.stud());
        MPSiteType[] types = Iterables.toArray(MPSiteType.forClass(MPSiteTypeClass.Generated), MPSiteType.class);
        Component[] componentArray2 = new Component[5];
        this.siteTypeField = Components.comboBox(types);
        componentArray2[0] = this.siteTypeField;
        componentArray2[1] = Components.stud();
        this.siteVersionField = Components.comboBox(MasterKey.Version.values());
        componentArray2[2] = this.siteVersionField;
        componentArray2[3] = Components.stud();
        this.siteCounterField = Components.spinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        componentArray2[4] = this.siteCounterField;
        Components.GradientPanel siteSettings = Components.boxLayout(2, componentArray2);
        sitePanel.add(siteSettings);
        this.siteTypeField.setFont(Res.valueFont().deriveFont(12.0f));
        this.siteTypeField.setSelectedItem((Object)MPSiteType.GeneratedLong);
        this.siteTypeField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PasswordFrame.this.updatePassword(true);
            }
        });
        this.siteVersionField.setFont(Res.valueFont().deriveFont(12.0f));
        this.siteVersionField.setAlignmentX(1.0f);
        this.siteVersionField.setSelectedItem((Object)MasterKey.Version.CURRENT);
        this.siteVersionField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PasswordFrame.this.updatePassword(true);
            }
        });
        this.siteCounterField.setFont(Res.valueFont().deriveFont(12.0f));
        this.siteCounterField.setAlignmentX(1.0f);
        this.siteCounterField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PasswordFrame.this.updatePassword(true);
            }
        });
        this.maskPasswordField = Components.checkBox("Hide Password");
        this.maskPasswordField.setAlignmentX(0.5f);
        this.maskPasswordField.setSelected(true);
        this.maskPasswordField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PasswordFrame.this.updateMask();
            }
        });
        this.passwordField = Components.passwordField();
        this.passwordField.setAlignmentX(0.5f);
        this.passwordField.setHorizontalAlignment(0);
        this.passwordField.putClientProperty("JPasswordField.cutCopyAllowed", true);
        this.passwordField.setEditable(false);
        this.passwordField.setBackground(null);
        this.passwordField.setBorder(null);
        this.passwordEchoChar = this.passwordField.getEchoChar();
        this.passwordEchoFont = this.passwordField.getFont().deriveFont(40.0f);
        this.updateMask();
        this.tipLabel = Components.label(" ", 0);
        this.tipLabel.setAlignmentX(0.5f);
        Components.GradientPanel passwordContainer = Components.boxLayout(3, this.maskPasswordField, Box.createGlue(), this.passwordField, Box.createGlue(), this.tipLabel);
        passwordContainer.setOpaque(true);
        passwordContainer.setBackground(Color.white);
        passwordContainer.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.root.add(Box.createVerticalStrut(8));
        this.root.add((Component)Components.borderPanel(passwordContainer, BorderFactory.createLoweredSoftBevelBorder(), Res.colors().frameBg()), "South");
        this.pack();
        this.setMinimumSize(new Dimension(Math.max(600, this.getPreferredSize().width), Math.max(300, this.getPreferredSize().height)));
        this.pack();
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(null);
    }

    private void updateMask() {
        this.passwordField.setEchoChar(this.maskPasswordField.isSelected() ? this.passwordEchoChar : (char)'\u0000');
        this.passwordField.setFont(this.maskPasswordField.isSelected() ? this.passwordEchoFont : Res.bigValueFont().deriveFont(40.0f));
    }

    @Nonnull
    private ListenableFuture<String> updatePassword(boolean allowNameCompletion) {
        final String siteNameQuery = this.siteNameField.getText();
        if (this.updatingUI) {
            return Futures.immediateCancelledFuture();
        }
        if (siteNameQuery == null || siteNameQuery.isEmpty() || !this.user.isKeyAvailable()) {
            this.siteActionButton.setVisible(false);
            this.tipLabel.setText(null);
            this.passwordField.setText(null);
            return Futures.immediateCancelledFuture();
        }
        MPSiteType siteType = (MPSiteType)((Object)this.siteTypeField.getModel().getElementAt(this.siteTypeField.getSelectedIndex()));
        MasterKey.Version siteVersion = this.siteVersionField.getItemAt(this.siteVersionField.getSelectedIndex());
        int siteCounter = (Integer)this.siteCounterField.getValue();
        Iterable<Site> siteResults = this.user.findSitesByName(siteNameQuery);
        if (!allowNameCompletion) {
            siteResults = FluentIterable.from(siteResults).filter((Predicate<Site>)new PredicateNN<Site>(){

                @Override
                public boolean apply(Site input) {
                    return siteNameQuery.equals(input.getSiteName());
                }
            });
        }
        final Site site = Iterables.getFirst(siteResults, new IncognitoSite(siteNameQuery, siteType, siteCounter, siteVersion));
        if (this.currentSite != null && site.getSiteName().equals(this.currentSite.getSiteName())) {
            site.setSiteType(siteType);
            site.setAlgorithmVersion(siteVersion);
            site.setSiteCounter(siteCounter);
        }
        ListenableFuture<String> passwordFuture = Res.execute((Window)this, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return PasswordFrame.this.user.getKey(site.getAlgorithmVersion()).encode(site.getSiteName(), site.getSiteType(), site.getSiteCounter(), MPSiteVariant.Password, null);
            }
        });
        Futures.addCallback(passwordFuture, new FutureCallback<String>(){

            @Override
            public void onSuccess(final @Nullable String sitePassword) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PasswordFrame.this.updatingUI = true;
                        PasswordFrame.this.currentSite = site;
                        PasswordFrame.this.siteActionButton.setVisible(PasswordFrame.this.user instanceof ModelUser);
                        if (PasswordFrame.this.currentSite instanceof ModelSite) {
                            PasswordFrame.this.siteActionButton.setText("Delete Site");
                        } else {
                            PasswordFrame.this.siteActionButton.setText("Add Site");
                        }
                        PasswordFrame.this.siteTypeField.setSelectedItem((Object)PasswordFrame.this.currentSite.getSiteType());
                        PasswordFrame.this.siteVersionField.setSelectedItem((Object)PasswordFrame.this.currentSite.getAlgorithmVersion());
                        PasswordFrame.this.siteCounterField.setValue(PasswordFrame.this.currentSite.getSiteCounter());
                        PasswordFrame.this.siteNameField.setText(PasswordFrame.this.currentSite.getSiteName());
                        if (PasswordFrame.this.siteNameField.getText().startsWith(siteNameQuery)) {
                            PasswordFrame.this.siteNameField.select(siteNameQuery.length(), PasswordFrame.this.siteNameField.getText().length());
                        }
                        PasswordFrame.this.passwordField.setText(sitePassword);
                        PasswordFrame.this.tipLabel.setText("Press [Enter] to copy the password.  Then paste it into the password field.");
                        PasswordFrame.this.updatingUI = false;
                    }
                });
            }

            @Override
            public void onFailure(Throwable t) {
            }
        });
        return passwordFuture;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updatePassword(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updatePassword(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updatePassword(true);
    }
}

