/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.ObjectUtils;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import com.lyndir.masterpassword.MPIdenticon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class Res {
    private static final WeakHashMap<Window, ExecutorService> executorByWindow = new WeakHashMap();
    private static final Logger logger = Logger.get(Res.class);
    private static final Colors colors = new Colors();

    public static Future<?> execute(Window host, final Runnable job) {
        return Res.getExecutor(host).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    job.run();
                }
                catch (Throwable t) {
                    logger.err(t, "Unexpected: %s", t.getLocalizedMessage());
                }
            }
        });
    }

    public static <V> ListenableFuture<V> execute(Window host, final Callable<V> job) {
        ExecutorService executor = Res.getExecutor(host);
        return JdkFutureAdapters.listenInPoolThread(executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    return job.call();
                }
                catch (Throwable t) {
                    logger.err(t, "Unexpected: %s", t.getLocalizedMessage());
                    throw t;
                }
            }
        }), executor);
    }

    private static ExecutorService getExecutor(final Window host) {
        ExecutorService executor = executorByWindow.get(host);
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
            executorByWindow.put(host, executor);
            host.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    ExecutorService executor = (ExecutorService)executorByWindow.remove(host);
                    if (executor != null) {
                        executor.shutdownNow();
                    }
                }
            });
        }
        return executor;
    }

    public static Icon iconAdd() {
        return new RetinaIcon(Resources.getResource("media/icon_add@2x.png"));
    }

    public static Icon iconDelete() {
        return new RetinaIcon(Resources.getResource("media/icon_delete@2x.png"));
    }

    public static Icon iconQuestion() {
        return new RetinaIcon(Resources.getResource("media/icon_question@2x.png"));
    }

    public static Icon avatar(int index) {
        return new RetinaIcon(Resources.getResource(StringUtils.strf("media/avatar-%d@2x.png", index % Res.avatars())));
    }

    public static int avatars() {
        return 19;
    }

    public static Font emoticonsFont() {
        return Res.emoticonsRegular();
    }

    public static Font controlFont() {
        return Res.arimoRegular();
    }

    public static Font valueFont() {
        return Res.sourceSansProRegular();
    }

    public static Font bigValueFont() {
        return Res.sourceSansProBlack();
    }

    public static Font emoticonsRegular() {
        return Res.font("fonts/Emoticons-Regular.otf");
    }

    public static Font sourceCodeProRegular() {
        return Res.font("fonts/SourceCodePro-Regular.otf");
    }

    public static Font sourceCodeProBlack() {
        return Res.font("fonts/SourceCodePro-Bold.otf");
    }

    public static Font sourceSansProRegular() {
        return Res.font("fonts/SourceSansPro-Regular.otf");
    }

    public static Font sourceSansProBlack() {
        return Res.font("fonts/SourceSansPro-Bold.otf");
    }

    public static Font exoBold() {
        return Res.font("fonts/Exo2.0-Bold.otf");
    }

    public static Font exoExtraBold() {
        return Res.font("fonts/Exo2.0-ExtraBold.otf");
    }

    public static Font exoRegular() {
        return Res.font("fonts/Exo2.0-Regular.otf");
    }

    public static Font exoThin() {
        return Res.font("fonts/Exo2.0-Thin.otf");
    }

    public static Font arimoBold() {
        return Res.font("fonts/Arimo-Bold.ttf");
    }

    public static Font arimoBoldItalic() {
        return Res.font("fonts/Arimo-BoldItalic.ttf");
    }

    public static Font arimoItalic() {
        return Res.font("fonts/Arimo-Italic.ttf");
    }

    public static Font arimoRegular() {
        return Res.font("fonts/Arimo-Regular.ttf");
    }

    private static Font font(String fontResourceName) {
        Font font;
        HashMap<String, SoftReference<Font>> fontsByResourceName = Maps.newHashMap();
        SoftReference fontRef = (SoftReference)fontsByResourceName.get(fontResourceName);
        Font font2 = font = fontRef == null ? null : (Font)fontRef.get();
        if (font == null) {
            try {
                font = Font.createFont(0, Resources.getResource(fontResourceName).openStream());
                fontsByResourceName.put(fontResourceName, new SoftReference<Font>(font));
            }
            catch (FontFormatException | IOException e) {
                throw Throwables.propagate(e);
            }
        }
        return font;
    }

    public static Colors colors() {
        return colors;
    }

    public static class Colors {
        private final Color frameBg = Color.decode("#5A5D6B");
        private final Color controlBg = Color.decode("#ECECEC");
        private final Color controlBorder = Color.decode("#BFBFBF");

        public Color frameBg() {
            return this.frameBg;
        }

        public Color controlBg() {
            return this.controlBg;
        }

        public Color controlBorder() {
            return this.controlBorder;
        }

        public Color fromIdenticonColor(MPIdenticon.Color identiconColor, BackgroundMode backgroundMode) {
            switch (identiconColor) {
                case RED: {
                    switch (backgroundMode) {
                        case DARK: {
                            return Color.decode("#dc322f");
                        }
                        case LIGHT: {
                            return Color.decode("#dc322f");
                        }
                    }
                    break;
                }
                case GREEN: {
                    switch (backgroundMode) {
                        case DARK: {
                            return Color.decode("#859900");
                        }
                        case LIGHT: {
                            return Color.decode("#859900");
                        }
                    }
                    break;
                }
                case YELLOW: {
                    switch (backgroundMode) {
                        case DARK: {
                            return Color.decode("#b58900");
                        }
                        case LIGHT: {
                            return Color.decode("#b58900");
                        }
                    }
                    break;
                }
                case BLUE: {
                    switch (backgroundMode) {
                        case DARK: {
                            return Color.decode("#268bd2");
                        }
                        case LIGHT: {
                            return Color.decode("#268bd2");
                        }
                    }
                    break;
                }
                case MAGENTA: {
                    switch (backgroundMode) {
                        case DARK: {
                            return Color.decode("#d33682");
                        }
                        case LIGHT: {
                            return Color.decode("#d33682");
                        }
                    }
                    break;
                }
                case CYAN: {
                    switch (backgroundMode) {
                        case DARK: {
                            return Color.decode("#2aa198");
                        }
                        case LIGHT: {
                            return Color.decode("#2aa198");
                        }
                    }
                    break;
                }
                case MONO: {
                    switch (backgroundMode) {
                        case DARK: {
                            return Color.decode("#93a1a1");
                        }
                        case LIGHT: {
                            return Color.decode("#586e75");
                        }
                    }
                }
            }
            throw new IllegalArgumentException(StringUtils.strf("Color: %s or mode: %s not supported: ", new Object[]{identiconColor, backgroundMode}));
        }

        public static enum BackgroundMode {
            DARK,
            LIGHT;

        }
    }

    private static final class RetinaIcon
    extends ImageIcon {
        private static final Pattern scalePattern = Pattern.compile(".*@(\\d+)x.[^.]+$");
        private final float scale;

        public RetinaIcon(URL url) {
            super(url);
            Matcher scaleMatcher = scalePattern.matcher(url.getPath());
            this.scale = scaleMatcher.matches() ? Float.parseFloat(scaleMatcher.group(1)) : 1.0f;
        }

        @Override
        public int getIconWidth() {
            return (int)((float)super.getIconWidth() / this.scale);
        }

        @Override
        public int getIconHeight() {
            return (int)((float)super.getIconHeight() / this.scale);
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            ImageObserver observer = ObjectUtils.ifNotNullElse(this.getImageObserver(), c);
            Image image = this.getImage();
            int width = image.getWidth(observer);
            int height = image.getHeight(observer);
            Graphics2D g2d = (Graphics2D)g.create(x, y, width, height);
            g2d.scale(1.0f / this.scale, 1.0f / this.scale);
            g2d.drawImage(image, 0, 0, observer);
            g2d.scale(1.0, 1.0);
            g2d.dispose();
        }
    }
}

