/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.lyndir.lhunath.opal.system.util.ObjectUtils;
import com.lyndir.masterpassword.MPIdenticon;
import com.lyndir.masterpassword.gui.AuthenticationPanel;
import com.lyndir.masterpassword.gui.IncognitoAuthenticationPanel;
import com.lyndir.masterpassword.gui.ModelAuthenticationPanel;
import com.lyndir.masterpassword.gui.Res;
import com.lyndir.masterpassword.gui.User;
import com.lyndir.masterpassword.gui.util.Components;
import com.lyndir.masterpassword.model.IncorrectMasterPasswordException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UnlockFrame
extends JFrame {
    private final SignInCallback signInCallback;
    private final Components.GradientPanel root;
    private final JLabel identiconLabel;
    private final JButton signInButton;
    private final JPanel authenticationContainer;
    private AuthenticationPanel authenticationPanel;
    private boolean incognito;
    public User user;

    public UnlockFrame(SignInCallback signInCallback) throws HeadlessException {
        super("Unlock Master Password");
        this.signInCallback = signInCallback;
        this.setDefaultCloseOperation(2);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                UnlockFrame.this.root.setGradientColor(Res.colors().frameBg());
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                UnlockFrame.this.root.setGradientColor(Color.RED);
            }
        });
        Component[] componentArray = new Component[3];
        componentArray[0] = Box.createGlue();
        this.signInButton = Components.button("Sign In");
        componentArray[1] = this.signInButton;
        componentArray[2] = Box.createGlue();
        Components.GradientPanel signInBox = Components.boxLayout(2, componentArray);
        signInBox.setBackground(null);
        this.root = Components.gradientPanel(new FlowLayout(), Res.colors().frameBg());
        this.setContentPane(this.root);
        this.root.setLayout(new BoxLayout(this.root, 3));
        this.root.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.authenticationContainer = Components.boxLayout(3, new Component[0]);
        this.root.add(Components.borderPanel(this.authenticationContainer, BorderFactory.createRaisedBevelBorder(), Res.colors().frameBg()));
        this.root.add(Box.createVerticalStrut(8));
        this.identiconLabel = Components.label(" ", 0);
        this.root.add(this.identiconLabel);
        this.root.add(Box.createVerticalStrut(8));
        this.root.add(signInBox);
        this.authenticationContainer.setOpaque(true);
        this.authenticationContainer.setBackground(Res.colors().controlBg());
        this.authenticationContainer.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.identiconLabel.setFont(Res.emoticonsFont().deriveFont(14.0f));
        this.identiconLabel.setToolTipText("A representation of your identity across all Master Password apps.\nIt should always be the same.");
        this.signInButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnlockFrame.this.trySignIn(new JComponent[0]);
            }
        });
        this.createAuthenticationPanel();
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(null);
    }

    protected void repack() {
        this.pack();
        this.setMinimumSize(new Dimension(Math.max(300, this.getPreferredSize().width), Math.max(300, this.getPreferredSize().height)));
        this.pack();
    }

    private void createAuthenticationPanel() {
        this.authenticationContainer.removeAll();
        this.authenticationPanel = this.incognito ? new IncognitoAuthenticationPanel(this) : new ModelAuthenticationPanel(this);
        this.authenticationPanel.updateUser(false);
        this.authenticationContainer.add(this.authenticationPanel);
        this.authenticationContainer.add(Components.stud());
        final JCheckBox incognitoCheckBox = Components.checkBox("Incognito");
        incognitoCheckBox.setToolTipText("Log in without saving any information.");
        incognitoCheckBox.setSelected(this.incognito);
        incognitoCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UnlockFrame.this.incognito = incognitoCheckBox.isSelected();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UnlockFrame.this.createAuthenticationPanel();
                    }
                });
            }
        });
        Components.GradientPanel toolsPanel = Components.boxLayout(2, incognitoCheckBox, Box.createGlue());
        this.authenticationContainer.add(toolsPanel);
        for (JButton jButton : this.authenticationPanel.getButtons()) {
            toolsPanel.add(jButton);
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setAlignmentX(1.0f);
            jButton.setContentAreaFilled(false);
        }
        this.checkSignIn();
        this.validate();
        this.repack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Component)ObjectUtils.ifNotNullElse(UnlockFrame.this.authenticationPanel.getFocusComponent(), UnlockFrame.this.signInButton)).requestFocusInWindow();
            }
        });
    }

    void updateUser(@Nullable User user) {
        this.user = user;
        this.checkSignIn();
    }

    boolean checkSignIn() {
        boolean enabled;
        String fullName = this.user == null ? "" : this.user.getFullName();
        char[] masterPassword = this.authenticationPanel.getMasterPassword();
        boolean bl = enabled = !fullName.isEmpty() && masterPassword.length > 0;
        if (fullName.isEmpty() || masterPassword.length == 0) {
            this.identiconLabel.setText(" ");
        } else {
            MPIdenticon identicon = new MPIdenticon(fullName, masterPassword);
            this.identiconLabel.setText(identicon.getText());
            this.identiconLabel.setForeground(Res.colors().fromIdenticonColor(identicon.getColor(), Res.Colors.BackgroundMode.DARK));
        }
        this.signInButton.setEnabled(enabled);
        return enabled;
    }

    void trySignIn(final JComponent ... signInComponents) {
        if (!this.checkSignIn()) {
            return;
        }
        for (JComponent signInComponent : signInComponents) {
            signInComponent.setEnabled(false);
        }
        this.signInButton.setEnabled(false);
        this.signInButton.setText("Signing In...");
        Res.execute((Window)this, new Runnable(){

            @Override
            public void run() {
                try {
                    UnlockFrame.this.user.authenticate(UnlockFrame.this.authenticationPanel.getMasterPassword());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UnlockFrame.this.signInCallback.signedIn(UnlockFrame.this.user);
                            UnlockFrame.this.dispose();
                        }
                    });
                }
                catch (IncorrectMasterPasswordException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "Sign In Failed", 0);
                            UnlockFrame.this.authenticationPanel.reset();
                            UnlockFrame.this.signInButton.setText("Sign In");
                            for (JComponent signInComponent : signInComponents) {
                                signInComponent.setEnabled(true);
                            }
                            UnlockFrame.this.checkSignIn();
                        }
                    });
                }
            }
        });
    }

    static interface SignInCallback {
        public void signedIn(User var1);
    }
}

