/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.lyndir.masterpassword.MasterKey;
import com.lyndir.masterpassword.gui.Site;
import com.lyndir.masterpassword.model.IncorrectMasterPasswordException;
import java.util.EnumMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class User {
    @Nonnull
    private final EnumMap<MasterKey.Version, MasterKey> keyByVersion = Maps.newEnumMap(MasterKey.Version.class);

    public abstract String getFullName();

    @Nullable
    protected abstract char[] getMasterPassword();

    public abstract void authenticate(char[] var1) throws IncorrectMasterPasswordException;

    public int getAvatar() {
        return 0;
    }

    public boolean isKeyAvailable() {
        return this.getMasterPassword() != null;
    }

    @Nonnull
    public MasterKey getKey(MasterKey.Version algorithmVersion) {
        char[] masterPassword = Preconditions.checkNotNull(this.getMasterPassword(), "User is not authenticated: " + this.getFullName());
        MasterKey key = this.keyByVersion.get((Object)algorithmVersion);
        if (key == null) {
            key = MasterKey.create(algorithmVersion, this.getFullName(), masterPassword);
            this.putKey(key);
        }
        if (!key.isValid()) {
            key.revalidate(masterPassword);
        }
        return key;
    }

    protected void putKey(MasterKey masterKey) {
        MasterKey oldKey = this.keyByVersion.put(masterKey.getAlgorithmVersion(), masterKey);
        if (oldKey != null) {
            oldKey.invalidate();
        }
    }

    public void reset() {
        for (MasterKey key : this.keyByVersion.values()) {
            key.invalidate();
        }
    }

    public abstract Iterable<Site> findSitesByName(String var1);

    public abstract void addSite(Site var1);

    public abstract void deleteSite(Site var1);

    public boolean equals(Object obj) {
        return this == obj || obj instanceof User && Objects.equals(this.getFullName(), ((User)obj).getFullName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getFullName());
    }

    public String toString() {
        return this.getFullName();
    }
}

