/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.gui.util;

import com.lyndir.masterpassword.gui.Res;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public abstract class Components {
    public static GradientPanel boxLayout(int axis, Component ... components) {
        GradientPanel container = Components.gradientPanel(null, null);
        container.setLayout(new BoxLayout(container, axis));
        for (Component component : components) {
            container.add(component);
        }
        return container;
    }

    public static GradientPanel borderPanel(JComponent component, @Nullable Border border) {
        return Components.borderPanel(component, border, null);
    }

    public static GradientPanel borderPanel(JComponent component, @Nullable Border border, @Nullable Color background) {
        GradientPanel box = Components.boxLayout(2, component);
        if (border != null) {
            box.setBorder(border);
        }
        if (background != null) {
            box.setBackground(background);
        }
        return box;
    }

    public static GradientPanel gradientPanel(@Nullable LayoutManager layout, final @Nullable Color color) {
        return new GradientPanel(layout, color){
            {
                super(layout, gradientColor);
                this.setOpaque(color != null);
                this.setBackground(null);
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
            }
        };
    }

    public static JTextField textField() {
        return new JTextField(){
            {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Res.colors().controlBorder(), 1, true), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
                this.setFont(Res.valueFont().deriveFont(12.0f));
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
    }

    public static JPasswordField passwordField() {
        return new JPasswordField(){
            {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Res.colors().controlBorder(), 1, true), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
    }

    public static JButton button(String label) {
        return new JButton(label){
            {
                this.setFont(Res.controlFont().deriveFont(12.0f));
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(20, this.getPreferredSize().height);
            }
        };
    }

    public static Component stud() {
        Dimension studDimension = new Dimension(8, 8);
        Box.Filler rigidArea = new Box.Filler(studDimension, studDimension, studDimension);
        rigidArea.setAlignmentX(0.0f);
        rigidArea.setAlignmentY(1.0f);
        rigidArea.setBackground(Color.red);
        return rigidArea;
    }

    public static JSpinner spinner(SpinnerModel model) {
        return new JSpinner(model){
            {
                CompoundBorder editorBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Res.colors().controlBorder(), 1, true), BorderFactory.createEmptyBorder(4, 4, 4, 4));
                ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setBorder(editorBorder);
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
                this.setBorder(null);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(20, this.getPreferredSize().height);
            }
        };
    }

    public static JLabel label(@Nullable String label) {
        return Components.label(label, 10);
    }

    public static JLabel label(@Nullable String label, int horizontalAlignment) {
        return new JLabel(label, horizontalAlignment){
            {
                this.setFont(Res.controlFont().deriveFont(12.0f));
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
    }

    public static JCheckBox checkBox(String label) {
        return new JCheckBox(label){
            {
                this.setFont(Res.controlFont().deriveFont(12.0f));
                this.setBackground(null);
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
            }
        };
    }

    @SafeVarargs
    public static <V> JComboBox<V> comboBox(V ... values) {
        return Components.comboBox(new DefaultComboBoxModel<V>(values));
    }

    public static <M> JComboBox<M> comboBox(ComboBoxModel<M> model) {
        return new JComboBox<M>((ComboBoxModel)model){
            {
                this.setFont(Res.controlFont().deriveFont(12.0f));
                this.setAlignmentX(0.0f);
                this.setAlignmentY(1.0f);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
    }

    public static class GradientPanel
    extends JPanel {
        @Nullable
        private Color gradientColor;
        @Nullable
        private GradientPaint paint;

        protected GradientPanel(@Nullable LayoutManager layout, @Nullable Color gradientColor) {
            super(layout);
            this.gradientColor = gradientColor;
            this.setBackground(null);
        }

        @Nullable
        public Color getGradientColor() {
            return this.gradientColor;
        }

        public void setGradientColor(@Nullable Color gradientColor) {
            this.gradientColor = gradientColor;
            this.revalidate();
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (this.gradientColor != null) {
                this.paint = new GradientPaint(new Point(0, 0), this.gradientColor, new Point(this.getWidth(), this.getHeight()), this.gradientColor.darker());
                this.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.paint != null) {
                ((Graphics2D)g).setPaint(this.paint);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

