/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.model;

import com.lyndir.lhunath.opal.system.util.StringUtils;
import com.lyndir.masterpassword.MPSiteType;
import com.lyndir.masterpassword.MPSiteVariant;
import com.lyndir.masterpassword.MasterKey;
import com.lyndir.masterpassword.model.MPUser;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Instant;

public class MPSite {
    public static final MPSiteType DEFAULT_TYPE = MPSiteType.GeneratedLong;
    public static final int DEFAULT_COUNTER = 1;
    private final MPUser user;
    private MasterKey.Version algorithmVersion;
    private Instant lastUsed;
    private String siteName;
    private MPSiteType siteType;
    private int siteCounter;
    private int uses;
    private String loginName;

    public MPSite(MPUser user, String siteName) {
        this(user, siteName, DEFAULT_TYPE, 1);
    }

    public MPSite(MPUser user, String siteName, MPSiteType siteType, int siteCounter) {
        this.user = user;
        this.algorithmVersion = MasterKey.Version.CURRENT;
        this.lastUsed = new Instant();
        this.siteName = siteName;
        this.siteType = siteType;
        this.siteCounter = siteCounter;
    }

    protected MPSite(MPUser user, MasterKey.Version algorithmVersion, Instant lastUsed, String siteName, MPSiteType siteType, int siteCounter, int uses, @Nullable String loginName, @Nullable String importContent) {
        this.user = user;
        this.algorithmVersion = algorithmVersion;
        this.lastUsed = lastUsed;
        this.siteName = siteName;
        this.siteType = siteType;
        this.siteCounter = siteCounter;
        this.uses = uses;
        this.loginName = loginName;
    }

    public String resultFor(MasterKey masterKey) {
        return this.resultFor(masterKey, MPSiteVariant.Password, null);
    }

    public String resultFor(MasterKey masterKey, MPSiteVariant variant, @Nullable String context) {
        return masterKey.encode(this.siteName, this.siteType, this.siteCounter, variant, context);
    }

    public MPUser getUser() {
        return this.user;
    }

    @Nullable
    protected String exportContent() {
        return null;
    }

    public MasterKey.Version getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(MasterKey.Version mpVersion) {
        this.algorithmVersion = mpVersion;
    }

    public Instant getLastUsed() {
        return this.lastUsed;
    }

    public void updateLastUsed() {
        this.lastUsed = new Instant();
        this.user.updateLastUsed();
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public MPSiteType getSiteType() {
        return this.siteType;
    }

    public void setSiteType(MPSiteType siteType) {
        this.siteType = siteType;
    }

    public int getSiteCounter() {
        return this.siteCounter;
    }

    public void setSiteCounter(int siteCounter) {
        this.siteCounter = siteCounter;
    }

    public int getUses() {
        return this.uses;
    }

    public void setUses(int uses) {
        this.uses = uses;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MPSite && Objects.equals(this.siteName, ((MPSite)obj).siteName);
    }

    public int hashCode() {
        return Objects.hashCode(this.siteName);
    }

    public String toString() {
        return StringUtils.strf("{MPSite: %s}", this.siteName);
    }
}

