/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.lyndir.lhunath.opal.system.CodeUtils;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.ConversionUtils;
import com.lyndir.lhunath.opal.system.util.NNOperation;
import com.lyndir.lhunath.opal.system.util.ObjectUtils;
import com.lyndir.masterpassword.MPSiteType;
import com.lyndir.masterpassword.MasterKey;
import com.lyndir.masterpassword.model.MPSite;
import com.lyndir.masterpassword.model.MPUser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MPSiteUnmarshaller {
    private static final Logger logger = Logger.get(MPSite.class);
    private static final DateTimeFormatter rfc3339 = ISODateTimeFormat.dateTimeNoMillis();
    private static final Pattern[] unmarshallFormats = new Pattern[]{Pattern.compile("^([^ ]+) +(\\d+) +(\\d+)(:\\d+)? +([^\t]+)\t(.*)"), Pattern.compile("^([^ ]+) +(\\d+) +(\\d+)(:\\d+)?(:\\d+)? +([^\t]*)\t *([^\t]+)\t(.*)")};
    private static final Pattern headerFormat = Pattern.compile("^#\\s*([^:]+): (.*)");
    private final int importFormat;
    private final int mpVersion;
    private final boolean clearContent;
    private final MPUser user;

    @Nonnull
    public static MPSiteUnmarshaller unmarshall(@Nonnull File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            MPSiteUnmarshaller mPSiteUnmarshaller = MPSiteUnmarshaller.unmarshall(CharStreams.readLines(reader));
            return mPSiteUnmarshaller;
        }
    }

    @Nonnull
    public static MPSiteUnmarshaller unmarshall(@Nonnull List<String> lines) {
        byte[] keyID = null;
        String fullName = null;
        int mpVersion = 0;
        int importFormat = 0;
        int avatar = 0;
        boolean clearContent = false;
        boolean headerStarted = false;
        MPSiteType defaultType = MPSiteType.GeneratedLong;
        MPSiteUnmarshaller marshaller = null;
        final ImmutableList.Builder sites = ImmutableList.builder();
        for (String line : lines) {
            if (line.startsWith("##")) {
                if (!headerStarted) {
                    headerStarted = true;
                    continue;
                }
                marshaller = new MPSiteUnmarshaller(importFormat, mpVersion, fullName, keyID, avatar, defaultType, clearContent);
                continue;
            }
            if (line.startsWith("#")) {
                Matcher headerMatcher;
                if (!headerStarted || marshaller != null || !(headerMatcher = headerFormat.matcher(line)).matches()) continue;
                String name = headerMatcher.group(1);
                String value = headerMatcher.group(2);
                if ("Full Name".equalsIgnoreCase(name) || "User Name".equalsIgnoreCase(name)) {
                    fullName = value;
                    continue;
                }
                if ("Key ID".equalsIgnoreCase(name)) {
                    keyID = CodeUtils.decodeHex(value);
                    continue;
                }
                if ("Algorithm".equalsIgnoreCase(name)) {
                    mpVersion = ConversionUtils.toIntegerNN(value);
                    continue;
                }
                if ("Format".equalsIgnoreCase(name)) {
                    importFormat = ConversionUtils.toIntegerNN(value);
                    continue;
                }
                if ("Avatar".equalsIgnoreCase(name)) {
                    avatar = ConversionUtils.toIntegerNN(value);
                    continue;
                }
                if ("Passwords".equalsIgnoreCase(name)) {
                    clearContent = value.equalsIgnoreCase("visible");
                    continue;
                }
                if (!"Default Type".equalsIgnoreCase(name)) continue;
                defaultType = MPSiteType.forType(ConversionUtils.toIntegerNN(value));
                continue;
            }
            if (marshaller == null) continue;
            ObjectUtils.ifNotNull(marshaller.unmarshallSite(line), new NNOperation<MPSite>(){

                @Override
                public void apply(@Nonnull MPSite site) {
                    sites.add(site);
                }
            });
        }
        return Preconditions.checkNotNull(marshaller, "No full header found in import file.");
    }

    protected MPSiteUnmarshaller(int importFormat, int mpVersion, String fullName, byte[] keyID, int avatar, MPSiteType defaultType, boolean clearContent) {
        this.importFormat = importFormat;
        this.mpVersion = mpVersion;
        this.clearContent = clearContent;
        this.user = new MPUser(fullName, keyID, MasterKey.Version.fromInt(mpVersion), avatar, defaultType, new DateTime(0L));
    }

    @Nullable
    public MPSite unmarshallSite(@Nonnull String siteLine) {
        MPSite site;
        Matcher siteMatcher = unmarshallFormats[this.importFormat].matcher(siteLine);
        if (!siteMatcher.matches()) {
            return null;
        }
        switch (this.importFormat) {
            case 0: {
                site = new MPSite(this.user, MasterKey.Version.fromInt(ConversionUtils.toIntegerNN(siteMatcher.group(4).replace(":", ""))), rfc3339.parseDateTime(siteMatcher.group(1)).toInstant(), siteMatcher.group(5), MPSiteType.forType(ConversionUtils.toIntegerNN(siteMatcher.group(3))), 1, ConversionUtils.toIntegerNN(siteMatcher.group(2)), null, siteMatcher.group(6));
                break;
            }
            case 1: {
                site = new MPSite(this.user, MasterKey.Version.fromInt(ConversionUtils.toIntegerNN(siteMatcher.group(4).replace(":", ""))), rfc3339.parseDateTime(siteMatcher.group(1)).toInstant(), siteMatcher.group(7), MPSiteType.forType(ConversionUtils.toIntegerNN(siteMatcher.group(3))), ConversionUtils.toIntegerNN(siteMatcher.group(5).replace(":", "")), ConversionUtils.toIntegerNN(siteMatcher.group(2)), siteMatcher.group(6), siteMatcher.group(8));
                break;
            }
            default: {
                throw logger.bug("Unexpected format: %d", this.importFormat);
            }
        }
        this.user.addSite(site);
        return site;
    }

    public MPUser getUser() {
        return this.user;
    }
}

