/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.lyndir.lhunath.opal.system.CodeUtils;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import com.lyndir.masterpassword.MPSiteType;
import com.lyndir.masterpassword.MasterKey;
import com.lyndir.masterpassword.model.IncorrectMasterPasswordException;
import com.lyndir.masterpassword.model.MPSite;
import com.lyndir.masterpassword.model.MPSiteResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class MPUser
implements Comparable<MPUser> {
    private final String fullName;
    private final Collection<MPSite> sites = Sets.newHashSet();
    @Nullable
    private byte[] keyID;
    private final MasterKey.Version algorithmVersion;
    private int avatar;
    private MPSiteType defaultType;
    private ReadableInstant lastUsed;

    public MPUser(String fullName) {
        this(fullName, null);
    }

    public MPUser(String fullName, @Nullable byte[] keyID) {
        this(fullName, keyID, MasterKey.Version.CURRENT, 0, MPSiteType.GeneratedLong, new DateTime());
    }

    public MPUser(String fullName, @Nullable byte[] keyID, MasterKey.Version algorithmVersion, int avatar, MPSiteType defaultType, ReadableInstant lastUsed) {
        this.fullName = fullName;
        this.keyID = keyID;
        this.algorithmVersion = algorithmVersion;
        this.avatar = avatar;
        this.defaultType = defaultType;
        this.lastUsed = lastUsed;
    }

    public Collection<MPSiteResult> findSitesByName(String query) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (MPSite site : this.getSites()) {
            if (!site.getSiteName().startsWith(query)) continue;
            results.add(new MPSiteResult(site));
        }
        return results.build();
    }

    public void addSite(MPSite site) {
        this.sites.add(site);
    }

    public void deleteSite(MPSite site) {
        this.sites.remove(site);
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean hasKeyID() {
        return this.keyID != null;
    }

    public String exportKeyID() {
        return CodeUtils.encodeHex(this.keyID);
    }

    @Nonnull
    public MasterKey authenticate(char[] masterPassword) throws IncorrectMasterPasswordException {
        MasterKey masterKey = MasterKey.create(this.algorithmVersion, this.getFullName(), masterPassword);
        if (this.keyID == null || this.keyID.length == 0) {
            this.keyID = masterKey.getKeyID();
        } else if (!Arrays.equals(masterKey.getKeyID(), this.keyID)) {
            throw new IncorrectMasterPasswordException(this);
        }
        return masterKey;
    }

    public int getAvatar() {
        return this.avatar;
    }

    public void setAvatar(int avatar) {
        this.avatar = avatar;
    }

    public MPSiteType getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(MPSiteType defaultType) {
        this.defaultType = defaultType;
    }

    public ReadableInstant getLastUsed() {
        return this.lastUsed;
    }

    public void updateLastUsed() {
        this.lastUsed = new Instant();
    }

    public Iterable<MPSite> getSites() {
        return this.sites;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MPUser && Objects.equals(this.fullName, ((MPUser)obj).fullName);
    }

    public int hashCode() {
        return Objects.hashCode(this.fullName);
    }

    public String toString() {
        return StringUtils.strf("{MPUser: %s}", this.fullName);
    }

    @Override
    public int compareTo(MPUser o) {
        int comparison = this.lastUsed.compareTo(o.lastUsed);
        if (comparison == 0) {
            comparison = this.fullName.compareTo(o.fullName);
        }
        return comparison;
    }
}

