/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSink;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.masterpassword.model.MPSiteMarshaller;
import com.lyndir.masterpassword.model.MPSiteUnmarshaller;
import com.lyndir.masterpassword.model.MPUser;
import com.lyndir.masterpassword.model.MPUserManager;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nullable;

public class MPUserFileManager
extends MPUserManager {
    private static final Logger logger = Logger.get(MPUserFileManager.class);
    private static final File mpwd = new File(System.getProperty("user.home"), ".mpw.d");
    private static final MPUserFileManager instance;
    private final File userFilesDirectory;

    public static MPUserFileManager get() {
        MPUserManager.instance = instance;
        return instance;
    }

    public static MPUserFileManager create(File userFilesDirectory) {
        return new MPUserFileManager(userFilesDirectory);
    }

    protected MPUserFileManager(File userFilesDirectory) {
        super(MPUserFileManager.unmarshallUsers(userFilesDirectory));
        this.userFilesDirectory = userFilesDirectory;
    }

    private static Iterable<MPUser> unmarshallUsers(File userFilesDirectory) {
        if (!userFilesDirectory.mkdirs() && !userFilesDirectory.isDirectory()) {
            logger.err("Couldn't create directory for user files: %s", userFilesDirectory);
            return ImmutableList.of();
        }
        return FluentIterable.from(ImmutableList.copyOf(userFilesDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".mpsites");
            }
        }))).transform(new Function<File, MPUser>(){

            @Override
            @Nullable
            public MPUser apply(@Nullable File file) {
                try {
                    return MPSiteUnmarshaller.unmarshall(Preconditions.checkNotNull(file)).getUser();
                }
                catch (IOException e) {
                    logger.err(e, "Couldn't read user from: %s", file);
                    return null;
                }
            }
        }).filter(Predicates.notNull());
    }

    @Override
    public void addUser(MPUser user) {
        super.addUser(user);
        this.save();
    }

    @Override
    public void deleteUser(MPUser user) {
        super.deleteUser(user);
        this.save();
    }

    public void save() {
        for (final MPUser user : this.getUsers()) {
            try {
                new CharSink(){

                    @Override
                    public Writer openStream() throws IOException {
                        return new FileWriter(new File(MPUserFileManager.this.userFilesDirectory, user.getFullName() + ".mpsites"));
                    }
                }.write(MPSiteMarshaller.marshallSafe(user).getExport());
            }
            catch (IOException e) {
                logger.err(e, "Unable to save sites for user: %s", user);
            }
        }
        for (File userFile : this.userFilesDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".mpsites");
            }
        })) {
            if (this.getUserNamed(userFile.getName().replaceFirst("\\.mpsites$", "")) != null || userFile.delete()) continue;
            logger.err("Couldn't delete file: %s", userFile);
        }
    }

    public File getPath() {
        return mpwd;
    }

    static {
        File mpwrc = new File(System.getProperty("user.home"), ".mpwrc");
        if (mpwrc.exists() && !mpwd.exists() && !mpwrc.renameTo(mpwd)) {
            logger.err("Couldn't migrate: %s -> %s", mpwrc, mpwd);
        }
        instance = MPUserFileManager.create(mpwd);
    }
}

