/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.masterpassword.model;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.lyndir.masterpassword.model.MPUser;
import java.util.Map;
import java.util.SortedSet;

public abstract class MPUserManager {
    private final Map<String, MPUser> usersByName = Maps.newHashMap();
    static MPUserManager instance;

    public static MPUserManager get() {
        return instance;
    }

    protected MPUserManager(Iterable<MPUser> users) {
        for (MPUser user : users) {
            this.usersByName.put(user.getFullName(), user);
        }
    }

    public SortedSet<MPUser> getUsers() {
        return FluentIterable.from(this.usersByName.values()).toSortedSet(Ordering.natural());
    }

    public MPUser getUserNamed(String fullName) {
        return this.usersByName.get(fullName);
    }

    public void addUser(MPUser user) {
        this.usersByName.put(user.getFullName(), user);
    }

    public void deleteUser(MPUser user) {
        this.usersByName.remove(user.getFullName());
    }
}

