/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.jms;

import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.fusesource.meshkeeper.control.ControlService;

public class ActiveMQControlService
implements ControlService {
    BrokerService controlBroker;
    String serviceUri;
    String directory = "activemq-control-service";

    public void setDirectory(String path) {
        this.directory = path;
    }

    public void start() throws Exception {
        this.controlBroker.setDataDirectory(this.directory);
        this.controlBroker.setUseShutdownHook(false);
        this.controlBroker.start();
        List connectors = this.controlBroker.getTransportConnectors();
        this.serviceUri = "activemq:" + this.externalizeUrl(((TransportConnector)connectors.get(0)).getConnectUri());
    }

    private URI externalizeUrl(URI uri) throws Exception {
        InetAddress address = InetAddress.getByName(uri.getHost());
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            String actualHost = InetAddress.getLocalHost().getCanonicalHostName();
            uri = new URI(uri.getScheme(), uri.getUserInfo(), actualHost, new Integer(uri.getPort()), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    public void destroy() throws Exception {
        if (this.controlBroker != null) {
            this.controlBroker.stop();
            this.controlBroker.waitUntilStopped();
            this.controlBroker = null;
        }
    }

    public String getName() {
        return "ActiveMQ Control Service at: " + this.getServiceUri();
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    static ActiveMQControlService create(URI uri) throws Exception {
        ActiveMQControlService rc = new ActiveMQControlService();
        BrokerService controlBroker = null;
        try {
            controlBroker = BrokerFactory.createBroker((URI)uri);
        }
        catch (Throwable thrown) {
            controlBroker = new BrokerService();
            controlBroker.setBrokerName("MeshKeeperControlBroker");
            controlBroker.addConnector(uri.toString());
            controlBroker.setDeleteAllMessagesOnStartup(true);
            controlBroker.setUseJmx(false);
        }
        rc.controlBroker = controlBroker;
        return rc;
    }
}

