/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.meshkeeper.distribution.registry.zk;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.fusesource.meshkeeper.RegistryWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZooKeeperChildWatcher {
    protected final ZooKeeper zk;
    protected final String path;
    private final Watcher watcher;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AsyncCallback.ChildrenCallback callback;
    private final HashSet<RegistryWatcher> watchers = new HashSet(1);

    public ZooKeeperChildWatcher(ZooKeeper zk, String path) {
        this.zk = zk;
        this.path = path;
        this.watcher = new Watcher(){

            public void process(WatchedEvent event) {
                switch (event.getType()) {
                    case NodeChildrenChanged: {
                        ZooKeeperChildWatcher.this.watch();
                        break;
                    }
                    default: {
                        System.out.println("WARNING Got:" + event);
                    }
                }
            }
        };
        this.callback = new AsyncCallback.ChildrenCallback(){

            public void processResult(int rc, String path, Object ctx, List<String> children) {
                ZooKeeperChildWatcher.this.handleChildUpdate(path, children);
            }
        };
    }

    private void handleChildUpdate(String path, List<String> children) {
        if (!this.started.get()) {
            return;
        }
        if (children == null) {
            children = new ArrayList<String>();
        }
        for (RegistryWatcher watcher : this.watchers) {
            watcher.onChildrenChanged(path, children);
        }
    }

    public void addWatcher(RegistryWatcher watcher) {
        if (this.watchers.add(watcher)) {
            this.start();
        }
    }

    public boolean removeWatcher(RegistryWatcher watcher) {
        this.watchers.remove(watcher);
        if (this.watchers.isEmpty()) {
            this.stop();
            return true;
        }
        return false;
    }

    private void start() {
        if (this.started.compareAndSet(false, true)) {
            this.watch();
        }
    }

    private void stop() {
        this.started.set(false);
    }

    private void watch() {
        if (this.started.get()) {
            this.zk.getChildren(this.path, this.watcher, this.callback, (Object)this.callback);
        }
    }
}

